//
// $Id: ProcessProbe.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  ProcessProbe
//  author: Jonathan Baker
//          Andrew Buttner
//          Michael Michnikov
//  date:   02/13/2004
//
//  Gathers process data.
//
//****************************************************************************************//

#ifndef _PROCESSPROBE_H_
#define _PROCESSPROBE_H_

#include "Probe.h"

// Include the data class
#include "ProcessData.h"

#include <strings.h>
#include <dirent.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <iostream>
#include <string>

// Define some buffer lengths
#define CMDLINE_LEN 1024
#define SCHED_CLASS_LEN 128
#define TTY_LEN PATH_MAX

using namespace std;

class ProcessProbe : public Probe
{
 public:
  ProcessProbe();
  ~ProcessProbe();
  pdVector Run(ProbeData *);

 private:
  // Common methods
  void GetPSInfo(ProcessData *, pdVector*);
  int RetrieveCommandLine(char *process, char *cmdline, string *errMsg);
  int RetrieveStatFile(char *process, int *uid, int *pid, int *ppid, long *priority, unsigned long *starttime, string *errMsg);
  void RetrieveTTY(char *process, char *ttyName);
  int RetrieveUptime(unsigned long *uptime, string *errMsg);
};

#endif
