//
// $Id: FileProbe.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  FileProbe
//  author: Jonathan Baker
//			Andrew Buttner
//          Michael Michnikov
//  date:   02/17/2004
//
//  Gathers file information.
//
//****************************************************************************************//

#ifndef __FILEPROBE_H__
#define __FILEPROBE_H__

#include "Probe.h"

// Include the data classes
#include "FilePermissionData.h"
#include "FileAttributeData.h"

#include "Common.h"
#include "MD5.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
//#include <fcntl.h>
#include <time.h>
//#include <errno.h>


#include <dirent.h>
#include <limits.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;


class FileProbe : public Probe
{
	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
		FileProbe();
		~FileProbe();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
		pdVector Run(ProbeData*);

	private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
		pdVector Run(FileAttributeData*);
		pdVector Run(FilePermissionData*);
		void GetFileAttributes(FileAttributeData*);
		void GetFilePermissions(FilePermissionData*);
		void FindMatchingFiles(string pattern, sVector *matches, string currentDir = "/");
};

#endif
