//
// $Id: REGEX.h,v 1.2 2004/08/24 13:59:51 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter project.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// OVAL Query Interpreter; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	REGEX.h
//  author: Jon Baker	
//  date:   March 24 2004
//
//	This class uses the REGEX library found at www.REGEX.org for pattern matching. 
//	
//****************************************************************************************//
#ifndef __REGEX_H__
#define __REGEX_H__

#include "Exception.h"

//	required regex include
#include <pcre.h> 

#include <sstream>
#include <string>

using namespace std;

//	The MAXMATCHES constant should be used by any search method to ensure that
//	endless/excessive matching searching doesn't occure. With out some sort of 
//	maximum it is possible to match so many items that the system would run out 
//	ov memory.
#define MAXMATCHES 5000

//****************************************************************************************//
//	Class : REGEX
//	The REGEX class will act as a container for all methods that use the REGEX library 
//****************************************************************************************//

class REGEX  
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	REGEX();
	~REGEX();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	string	EscapeRegexChars(string);
	int		FindFirstRegexChar(const string stringIn);
	int		FindLastRegexChar(const string stringIn);
	void	GetConstantPortion(string patternIn, string delimIn, string *patternOut, string *constOut);
	bool	IsMatch(const char*, const char*);
	string	RemoveExtraSlashes(string);
	void	Reset();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------	
	bool IsConstant(string);

	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------	
	int matchCount;
};


//	Define a REGEXException
class REGEXException : public Exception
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	REGEXException();
	REGEXException(string);
	REGEXException(string, int);
	~REGEXException();
};


#endif
