//
// $Id: Log.cpp,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//

#include "Log.h"

// Initialize static variables.

bool Log::verboseMode = false;
string Log::logFilename = "oval.log";

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Public Members  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

bool Log::ClearLogFile()
{
	//------------------------------------------------------------------------------------//
	//
	//  ABSTRACT
	//
	//  This function clears the existing log file.  Only return false if an existing
	//  file can not be deleted.
	//
	//------------------------------------------------------------------------------------//

	FILE* fp = NULL;
	fp = fopen(logFilename.c_str(), "w+"); 
	if (fp != NULL)
	{
		fclose(fp);
		return true;

	}

	return false;
}

void Log::WriteLog(string logMessageIn)
{
	//------------------------------------------------------------------------------------//
	//
	//  ABSTRACT
	//
	//  Writes the given message to the log file
	//
	//  The log file is opened using fopen with a mode of "a+".  This opens the file for
	//  reading and appending.  The appending operation includes the removal of the EOF
	//  marker before new data is written to the file and the EOF marker is restored after
	//  writing is complete.  The file is created first if it doesnt exist.
	//
	//  If an error occurs, ignore it.  Just means that the error message will not get
	//  written to the log file.
	//
	//------------------------------------------------------------------------------------//

	FILE* fp = NULL;

	fp = fopen(logFilename.c_str(), "a+");
	if (fp != NULL)
	{
		fputs(logMessageIn.c_str(), fp);
		fclose(fp);
	}
}
