//
// $Id: Exception.cpp,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//

#include "Exception.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Exception  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

Exception::Exception()
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  A simple constructor that defaults the severity to fatal
	//
	// -----------------------------------------------------------------------
	this->SetSeverity(ERROR_FATAL);
}

Exception::Exception(string msgIn)
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  A simple constructor that sets the err message and defaults the 
	//	severity to fatal for this exception
	//
	// -----------------------------------------------------------------------
	this->SetSeverity(ERROR_FATAL);
	this->SetErrorMessage(msgIn);

}

Exception::Exception(string msgIn, int severityIn)
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  A simple constructor that sets the error message and the severity ot
	//	this exception to the specified values
	//
	// -----------------------------------------------------------------------

	this->SetSeverity(severityIn);
	this->SetErrorMessage(msgIn);
}

Exception::~Exception()
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  Do nothing for now
	//
	// -----------------------------------------------------------------------
}

string Exception::GetErrorMessage()
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  Retrun the error message for this exception
	//
	// -----------------------------------------------------------------------
	return this->errorMessage;
}

int Exception::GetSeverity()
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  Return the severity of this exception
	//
	// -----------------------------------------------------------------------
	return this->severity;
}

void Exception::SetErrorMessage(string errorMessageIn)
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  Set the error message for this exception
	//
	// -----------------------------------------------------------------------
	this->errorMessage = errorMessageIn;
}

void Exception::SetSeverity(int severityIn)
{
	// -----------------------------------------------------------------------
	//  ABSTRACT
	//
	//  Set the severity of the exception
	//
	// -----------------------------------------------------------------------
	this->severity = severityIn;
}
