//
// $Id: ProcessData.cpp,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	ProcessData.cpp
//  author: Jon Baker	
//  date:   02 Februauy 2004
//
//	This calss will store all data for a red hat process tests. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "ProcessData.h"

//****************************************************************************************//
//								ProcessData Class								  //	
//****************************************************************************************//
ProcessData::ProcessData(string strCmdIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new ProcessData and populate with the node's data
	// -----------------------------------------------------------------------

	//	Init the data members
    testId = "";
	command = new TypedData(LITTERAL_TYPE, "");
	exec_time = "";
	pid = "";
	ppid = "";
	priority = "";
	scheduling_class = "";
	start_time = "";
	tty = "";
	user_id = "";
	msg = "";

	//	Call the parse function
	Parse(strCmdIn);
}

ProcessData::ProcessData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new ProcessData as an empty object.
	// -----------------------------------------------------------------------

    testId = "";
	command = new TypedData(LITTERAL_TYPE, "");
	exec_time = "";
	pid = "";
	ppid = "";
	priority = "";
	scheduling_class = "";
	start_time = "";
	tty = "";
	user_id = "";
	msg = "";
}

ProcessData::~ProcessData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void ProcessData::Write(DBInterface *db)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Write a process test to the database.
	//
	// -----------------------------------------------------------------------

	string sqlStmt = "";
	sqlStmt.append("INSERT INTO ");
	sqlStmt.append("RedHat_PSInfo VALUES (");

	//	user_id
	if(this->user_id.compare("") != 0) {
		sqlStmt.append("'" + this->user_id + "',");
	}else {
		sqlStmt.append("NULL,");
	}
	
	//	pid
	if(this->pid.compare("") != 0) {
		sqlStmt.append("'" + this->pid + "',");
	}else {
		sqlStmt.append("NULL,");
	}
	
	// ppid
	if(this->ppid.compare("") != 0) {
		sqlStmt.append("'" + this->ppid + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	scheduling_class
	if(this->scheduling_class.compare("") != 0) {
		sqlStmt.append("'" + this->scheduling_class + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	priority
	if(this->priority.compare("") != 0) {
		sqlStmt.append("'" + this->priority + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	start_time
	if(this->start_time.compare("") != 0) {
		sqlStmt.append("'" + this->start_time + "',");
	}else {
		sqlStmt.append("NULL,");
	}
	
	//	tty
	if(this->tty.compare("") != 0) {
		sqlStmt.append("'" + this->tty + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	exec_time
	if(this->exec_time.compare("") != 0) {
		sqlStmt.append("'" + this->exec_time + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	command
		if(this->command->data.compare("") != 0) {
		sqlStmt.append("'" + this->command->data + "'");
	}else {
		sqlStmt.append("NULL");
	}
	
	sqlStmt.append(")");


	// Update the database.
	if(this->command->data.compare("") != 0)
		db->ExecSQL(sqlStmt);


	//	Display any messages if running in verbose mode
	if(Log::verboseMode && this->msg.compare("") != 0)
	{
		string displayMsg = "\nMessage from the Process probe:\n";
		displayMsg.append("-------------------------------\n");
		displayMsg.append(this->msg);
		displayMsg.append("\n");
		
		cout << displayMsg << endl;;

		Log::WriteLog(displayMsg + "\n");
	}
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void ProcessData::Parse(string strCmdIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the command string to determine if it is a pattern match or
	//	a literal string.
	// -----------------------------------------------------------------------
	string strType = strCmdIn.substr(0,3);
	
	//	Get the type for the name
	if(strType.compare("LIT") == 0)
		this->command->type = LITTERAL_TYPE;
	else
		this->command->type = PATTERN_MATCH_TYPE;

	//	Set the value of the name
	this->command->data = strCmdIn.substr(4, strCmdIn.length() -4);

}
