//
// $Id: InetListeningServersData.cpp,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//

#include "InetListeningServersData.h"

//****************************************************************************************//
//						InetListeningServersData Class									  //	
//****************************************************************************************//
InetListeningServersData::InetListeningServersData(string strPrgNameIn)
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Initialize a new InetListeningServersData and populate 
  //	with the node's data
  // -----------------------------------------------------------------------

  //	Init the data members
  testId = "";
  program_name = new TypedData(LITTERAL_TYPE, "");
  local_full_address = "";
  local_address = "";
  local_port = "";
  foreign_full_address = "";
  foreign_address = "";
  foreign_port = "";
  user_id = "";
  pid = "";
  protocol = "";
  msg = "";

  //	Call the parse function
  Parse(strPrgNameIn);
}

InetListeningServersData::InetListeningServersData()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Initialize a new InetListeningServersData as an empty object.
  // -----------------------------------------------------------------------

  //	Init the data members
  testId = "";
  program_name = new TypedData(LITTERAL_TYPE, "");
  local_full_address = "";
  local_address = "";
  local_port = "";
  foreign_full_address = "";
  foreign_address = "";
  foreign_port = "";
  user_id = "";
  pid = "";
  protocol = "";
  msg = "";
}

InetListeningServersData::~InetListeningServersData()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Do nothing for now
  // -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void InetListeningServersData::Write(DBInterface *db)
{
   // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Write the InetListeningServers data to the database
  //	
  // -----------------------------------------------------------------------

	string sqlStmt = "";
	sqlStmt.append("INSERT INTO ");
	sqlStmt.append("RedHat_InetListeningServers");
	sqlStmt.append(" VALUES (");

	//	protocol
	if(this->protocol.compare("") != 0) {
		sqlStmt.append("'" + this->protocol + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	local_full_address
	if(this->local_full_address.compare("") != 0) {
		sqlStmt.append("'" + this->local_full_address + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	local_address
	if(this->local_address.compare("") != 0) {
		sqlStmt.append("'" + this->local_address + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	local_port
	if(this->local_port.compare("") != 0) {
		sqlStmt.append("'" + this->local_port + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	foreign_full_address
	if(this->foreign_full_address.compare("") != 0) {
		sqlStmt.append("'" + this->foreign_full_address + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	foreign_address
	if(this->foreign_address.compare("") != 0) {
		sqlStmt.append("'" + this->foreign_address + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	foreign_port
	if(this->foreign_port.compare("") != 0) {
		sqlStmt.append("'" + this->foreign_port + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	user_id
	if(this->user_id.compare("") != 0) {
		sqlStmt.append("'" + this->user_id + "',");
	}else {
		sqlStmt.append("NULL,");
	}
	
	//	pid
	if(this->pid.compare("") != 0) {
		sqlStmt.append("'" + this->pid + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	program_name
	if(this->program_name->data.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->program_name->data) + "'");
	}else {
		sqlStmt.append("NULL");
	}

	sqlStmt.append(")");


	// Update the database if all fields are not NULL
	if(this->program_name->data.compare("") != 0) {
		db->ExecSQL(sqlStmt);
	}else if(this->msg.compare("") == 0) {
		this->msg = "Unknown error: No data found by Inet Listening Servers probe.";
	}


	//	Display any messages if running in verbose mode
	if(Log::verboseMode && this->msg.compare("") != 0)
	{
		string displayMsg = "\nMessage from the Inet Listening Servers probe:\n";
		displayMsg.append("--------------------------------------------\n");
		displayMsg.append(this->msg);
		
		cout << displayMsg << endl;;
		Log::WriteLog(displayMsg + "\n");
	}
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void InetListeningServersData::Parse(string strPrgNameIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the string to determine if the provided name is a litteral or
	//	a pattern match
	//
	// -----------------------------------------------------------------------

	string strType = strPrgNameIn.substr(0,3);
	
	//	Get the type for the name
	if(strType.compare("LIT") == 0)
		this->program_name->type = LITTERAL_TYPE;
	else
		this->program_name->type = PATTERN_MATCH_TYPE;

	//	Set the value of the name
	this->program_name->data = strPrgNameIn.substr(4, strPrgNameIn.length() -4);
}
