//
// $Id: Version.cpp,v 1.9 2004/10/20 17:09:04 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//

#include "Version.h"

// Define the version.  The build and date are automatically updated
// prior to each build.
//
#define VERSION "3.4"
#define BUILD 5

string Version::GetVersion() {
	// -----------------------------------------------------------------------
	//	ABSTRACT
	//
	//	Return the version of this interpreter as a string.
	//
	// -----------------------------------------------------------------------

	string version;
	version.append(VERSION);
    return(version);
}

string Version::GetBuild() {
	// -----------------------------------------------------------------------
	//	ABSTRACT
	//
	//	Return the build of this interpreter as a string.
	//
	// -----------------------------------------------------------------------

	string version;
	ostringstream bld;
	bld << BUILD;
	version.append(bld.str());
    return(version);
}

string Version::GetBuildDate() {
	// -----------------------------------------------------------------------
	//	ABSTRACT
	//
	//	Return the build date of this interpreter as a string.
	//
	// -----------------------------------------------------------------------

	string version;
	version.append(__DATE__);
	version.append(" ");
	version.append(__TIME__);
    return(version);
}
