//
// $Id: Main.h,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  author: Andrew Buttner
//  date:   05/15/2002
//
//    This is the main header file.
//
//****************************************************************************************//

#ifndef MAIN_H
#define MAIN_H

#ifdef WIN32
	#pragma warning(disable:4786)
	#define STRNICMP _strnicmp
	#define STRICMP _stricmp
	#define SUPPORTED_FAMILY "Windows"
#endif

#ifdef REDHAT
	#define STRNICMP strncasecmp
	#define STRICMP strcasecmp
	#define SUPPORTED_FAMILY "RedHat"
#endif

#include "Common.h"
#include "DBInterface.h"
#include "Exception.h"
#include "Log.h"
#include "MD5.h"
#include "QueryIdPair.h"
#include "Version.h"

#include <time.h>

#ifdef WIN32
	#include <windows.h>
	#include "windows/DataCollector.h"
#endif
#ifdef REDHAT
	#include "redhat/DataCollector.h"
#endif


#include <fstream>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

typedef vector < QueryIdPair*, allocator<QueryIdPair*> > qipVector;
typedef vector < string, allocator<string> > stringVector;

#define BUFFER_SIZE 4096

// Local Function Definitions.

string GetNextLine(FILE*);
void PrintNotVulnerableOutput(stringVector);
void PrintOutput(string);
string ReplaceExists(string);
void StartOutput();
void StopOutput();
void Usage(string);

// Local Variable Definitions.

string appVersion = "3.0";
string datafileVersion = "0.0";
string osName = "XXXXXXX_";

string logMessage = "";

qipVector queryVector;		// Query vector
qipVector::iterator qvIterator;

qipVector cfVector;			// Conf vector
qipVector::iterator cfIterator;

qipVector scVector;			// Schema vector
qipVector::iterator scIterator;

#endif
