//
// $Id: UnameData.cpp,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	UnameData.cpp
//  author: Jon Baker	
//  date:   02 Februauy 2004
//
//	This calss will store all data for a UnameData. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "UnameData.h"

//****************************************************************************************//
//								UnameData Class								  //	
//****************************************************************************************//
UnameData::UnameData(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new UnameData and populate with the node's data
	// -----------------------------------------------------------------------

	string testName;

	//	Validate the test node
	if(test->getNodeType() != DOMNode::ELEMENT_NODE )
	{
		throw ProbeDataException("Error: UnameData() Invalid test node specified. Only ELEMENT_NODE's are allowed.");
	}else
	{
		testName = DOMCommon::ToString(test->getNodeName());
		if(testName.compare("uname_test") != 0)
			throw ProbeDataException("Error: UnameData() Invalid test node specified. Received: " + testName);
	}

	//	Init the data members
	testId = "";
	machine_class = "";
	node_name = "";
	os_name = "";
	os_release = "";
	processor_type = "";
	msg = "";

	//	Call the parse node function
	ParseNode(test);
}

UnameData::UnameData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new UnameData as an empty object.
	// -----------------------------------------------------------------------
	testId = "";
	machine_class = "";
	node_name = "";
	os_name = "";
	os_release = "";
	os_version = "";
	processor_type = "";
	msg = "";
}

UnameData::~UnameData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void UnameData::Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a new uname_test node and add it to the dataDocument.
	//	
	// -----------------------------------------------------------------------

	//	Create a new test node
	DOMElement *uname_test = CreateNewTestNode(dataDocument, "uname_test");

	//	Add the machine_class element - as a string
	AddChildNode(dataDocument, uname_test, "machine_class", machine_class);

	//	Add the node_name element - as a string
	AddChildNode(dataDocument, uname_test, "node_name", node_name);
	
	//	Add the os_name element - as a string
	AddChildNode(dataDocument, uname_test, "os_name", os_name);
	
	//	Add the os_name element - as a string
	AddChildNode(dataDocument, uname_test, "os_release", os_release);

	//	Add the os_name element - as a string
	AddChildNode(dataDocument, uname_test, "os_version", os_version);

	//	Add the processor_type element - as a string
	AddChildNode(dataDocument, uname_test, "processor_type", processor_type);

	//	Add the message element - as a string
	AddChildNode(dataDocument, uname_test, "message", msg);

}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void UnameData::ParseNode(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to popular this UnameData
	//	Really just need to gather the Test id.
	// -----------------------------------------------------------------------

	///////////////////////////////////////////////////////////////////////////
	//	Get the test id
	///////////////////////////////////////////////////////////////////////////
	testId = DOMCommon::GetAttributeByName(test, "id");
	if(testId.compare("") == 0)
		throw ProbeDataException("Error: Unable to find the 'id' attribute for a uname test.");
/*
	//      Really only need to get the test id for a uname test
	///////////////////////////////////////////////////////////////////////////
	//	Gather the data needed to call the probe
	///////////////////////////////////////////////////////////////////////////
	string childName	= "";
	
	DOMNode *unameChild;
	DOMNodeList *unameChildList;

	//	get a list of the child nodes and their values
	unameChildList = test->getChildNodes();
	unsigned int index = 0;
	while(index < unameChildList->getLength())
	{
		unameChild = unameChildList->item(index);

		//	only concerned with ELEMENT_NODEs
		if (unameChild->getNodeType() == DOMNode::ELEMENT_NODE)
		{
			//	get the name of the child
			childName = DOMCommon::ToString(unameChild->getNodeName());
			
			//	Get the machine_class value	
			if(strncmp(childName.c_str(), "machine_class", 12)==0)
			{
				machine_class = DOMCommon::GetDataNodeValue(unameChild);
				
			//	Get the nade_name value
			}else if(strncmp(childName.c_str(), "node_name", 9)==0)
			{
				node_name = DOMCommon::GetDataNodeValue(unameChild);
			
			//	Get the os_name value
			}else if(strncmp(childName.c_str(), "os_name", 7)==0)
			{
				os_name = DOMCommon::GetDataNodeValue(unameChild);
		       
			//	Get the os_release value
			}else if(strncmp(childName.c_str(), "os_release", 10)==0)
			{
				os_release = DOMCommon::GetDataNodeValue(unameChild);

			//	Get the os_version value
			}else if(strncmp(childName.c_str(), "os_version", 10)==0)
			{
				os_version = DOMCommon::GetDataNodeValue(unameChild);

			//	Get the processor_type value
			}else if(strncmp(childName.c_str(), "processor_type", 14)==0)
			{
				processor_type = DOMCommon::GetDataNodeValue(unameChild);
			}
		}
		index ++;
	}
*/
}
