//
// $Id: InetListeningServersData.cpp,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//

#include "InetListeningServersData.h"

//****************************************************************************************//
//						InetListeningServersData Class							  //	
//****************************************************************************************//
InetListeningServersData::InetListeningServersData(DOMNode *test)
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Initialize a new InetListeningServersData and populate 
  //	with the node's data
  // -----------------------------------------------------------------------

  string testName;

  //	Validate the test node
  if(test->getNodeType() != DOMNode::ELEMENT_NODE )
    {
      throw ProbeDataException("Error: InetListeningServersData() Invalid test node specified. Only ELEMENT_NODE's are allowed.");
    }else
      {
	testName = DOMCommon::ToString(test->getNodeName());
	if(testName.compare("inetlisteningservers_test") != 0)
	  throw ProbeDataException("Error: InetListeningServersData() Invalid test node specified. Received: " + testName);
      }

  //	Init the data members
  testId = "";
  program_name = new TypedData(LITTERAL_TYPE, "");
  local_full_address = "";
  local_address = "";
  local_port = "";
  foreign_full_address = "";
  foreign_address = "";
  foreign_port = "";
  user_id = "";
  pid = "";
  protocol = "";
  msg = "";

  //	Call the parse node function
  ParseNode(test);
}

InetListeningServersData::InetListeningServersData()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Initialize a new InetListeningServersData as an empty object.
  // -----------------------------------------------------------------------

  //	Init the data members
  testId = "";
  program_name = new TypedData(LITTERAL_TYPE, "");
  local_full_address = "";
  local_address = "";
  local_port = "";
  foreign_full_address = "";
  foreign_address = "";
  foreign_port = "";
  user_id = "";
  pid = "";
  protocol = "";
  msg = "";
}

InetListeningServersData::~InetListeningServersData()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Do nothing for now
  // -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void InetListeningServersData::Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument)
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Create a new inetlisteningservers_test node and add it 
  //	to the dataDocument.
  //	
  // -----------------------------------------------------------------------

  //	Create a new test node
  DOMElement *myTest = CreateNewTestNode(dataDocument, "inetlisteningservers_test");

  //	Add the local_address element - as a string
  AddChildNode(dataDocument, myTest, "local_address", local_address);

  //	Add the local_full_address element - as a string
  AddChildNode(dataDocument, myTest, "local_full_address", local_full_address);

  //	Add the local_port element
  AddChildNode(dataDocument, myTest, "local_port", local_port, DetermineDataType(local_port));

  //	Add the foreign_address element - as a string
  AddChildNode(dataDocument, myTest, "foreign_address", foreign_address);

  //	Add the foreign_full_address element - as a string
  AddChildNode(dataDocument, myTest, "foreign_full_address", foreign_full_address);

  //	Add the foreign_port element
  AddChildNode(dataDocument, myTest, "foreign_port", foreign_port, DetermineDataType(foreign_port));

  //	Add the pid element
  AddChildNode(dataDocument, myTest, "pid", pid, DetermineDataType(pid));

  //	Add the program_name element - as a string
  AddChildNode(dataDocument, myTest, "program_name", program_name->data);

  //	Add the protocol element - as a string
  AddChildNode(dataDocument, myTest, "protocol", protocol);

  //	Add the user_id element
  AddChildNode(dataDocument, myTest, "user_id", user_id, DetermineDataType(user_id));

  //	Add the message element - as a string
  AddChildNode(dataDocument, myTest, "message", msg);
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void InetListeningServersData::ParseNode(DOMNode *test)
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Parse the node gathering all data to populate this
  //	InetListeningServersData object. 
  //	Really just need to gather the Test id and the program name
  // -----------------------------------------------------------------------

  ///////////////////////////////////////////////////////////////////////////
  //	Get the test id
  ///////////////////////////////////////////////////////////////////////////
  testId = DOMCommon::GetAttributeByName(test, "id");
  if(testId.compare("") == 0)
    throw ProbeDataException("Error: Unable to find the 'id' attribute for a Red Hat InetListeningServers test.");	


  ///////////////////////////////////////////////////////////////////////////
  //	Gather the data needed to call the probe
  ///////////////////////////////////////////////////////////////////////////
  string childName	= "";
  string childOp		= "";
	
  DOMNode *processChild;
  DOMNodeList *processChildList;

  //	get a list of the child nodes and their values
  processChildList = test->getChildNodes();
  unsigned int index = 0;
  while(index < processChildList->getLength())
    {
      processChild = processChildList->item(index);

      //	only concerned with ELEMENT_NODEs
      if (processChild->getNodeType() == DOMNode::ELEMENT_NODE)
	{
	  //	get the name of the child
	  childName = DOMCommon::ToString(processChild->getNodeName());

	  //	Get the child's operator
	  childOp = DOMCommon::GetAttributeByName(processChild, "operator");
			
	  //	Get the command value	
	  if(childName.compare("program_name")==0)
	    {
	      if(childOp.compare("pattern match") == 0)
		program_name->type = PATTERN_MATCH_TYPE;
	      else
		program_name->type = LITTERAL_TYPE;

	      program_name->data = DOMCommon::GetDataNodeValue(processChild);
	    }
	}
      index ++;
    }
}
