//
// $Id: FileAttributeData.h,v 1.2 2004/07/08 17:27:04 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	FileAttributeData.h
//  author: Jon Baker	
//  date:   12 February 2004
//
//	This class will store all data for a red hat file test.
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//
//	TO DO:
//	Move all data to private data - This will effect the probe...
//
//****************************************************************************************//

#ifndef __FILEATTRIBUTEDATA_H_
#define __FILEATTRIBUTEDATA_H_

#include "ProbeData.h"

class FileAttributeData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	FileAttributeData(DOMNode *test);
	FileAttributeData();
	~FileAttributeData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument);

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------
	TypedData *path;
	bool exists;
	string type;
	string group_id;
	string user_id;
	string a_time;
	string c_time;
	string m_time;
	string md5;
	string msg;

	//	A Vector used to store the components of the path
	//	TO DO: remove when Drew changes XML schema to <data><object> model
	nvpVector *nvpPath;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMNode *test);
};

#endif
