//
// $Id: DataCollector.h,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DataCollector
//  author: Jon Baker	
//  date:   06 February 2003
//
//	This class is the data collector for Red Hat. It extends DOMOvalDataCollector
//****************************************************************************************//

#ifndef __DATACOLLECTOR_H__
#define __DATACOLLECTOR_H__

#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <vector>

//	include the parent class.
#include "../DOMOvalDataCollector.h"

//	include the probe classes
#include "FileProbe.h"
#include "InetListeningServersProbe.h"
#include "ProcessProbe.h"
#include "RPMInfoProbe.h"
#include "RPMVersionCompareProbe.h"
#include "UnameProbe.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

#define MAXHOSTNAMELENGTH 128

class DataCollector : public DOMOvalDataCollector
{
 public:
  // -----------------------------------------------------------------------
  //	Constructors & Destructors
  // -----------------------------------------------------------------------
  DataCollector(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *oval, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *data);
  ~DataCollector();

  // -----------------------------------------------------------------------
  //	Public members
  // -----------------------------------------------------------------------
  void Run();

protected:
	// -----------------------------------------------------------------------
	//	Protected members
	// -----------------------------------------------------------------------
	string GetHostName();
	string GetIPAddress();

};

#endif
