//
// $Id: VariableCollector.h,v 1.1 2004/06/24 13:22:31 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// OVAL Definition Interpreter; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  VariableCollector
//  author: Jon Baker	
//  date:   22 June 2004
//
//	This class is responsible for the collecting variable values from the specified
//	variables file and setting those values in teh oval definitions that reference them.
//
//****************************************************************************************//

#ifndef __VARIABLECOLLECTOR_H__
#define __VARIABLECOLLECTOR_H__


//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>

#include "Common.h"
#include "Exception.h"
#include "DOMCommon.h"
#include "DOMProcessor.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;


class VariableCollector  
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	VariableCollector(DOMProcessor*, string, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*);
	virtual ~VariableCollector();
	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Run();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void GetVariableValue(string, string*, string*);
	void ProcessTest(DOMElement*);
	void SetValue(DOMElement*, string, string);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ovalDocument; 
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *variableDocument; 
};

//	Define an Exception class
class VariableCollectorException : public Exception
{
	public:

		VariableCollectorException();
		VariableCollectorException(string errorMessageIn);
		~VariableCollectorException();
};

#endif
