//
// $Id: Main.h,v 1.3 2004/07/08 19:50:44 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  author: Andrew Buttner & Jon Baker
//  date:   3/04/2004
//
//    This is the main header file.
//
//****************************************************************************************//

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

#include "Common.h"
#include "Log.h"
#include "MD5.h"
#include "DOMProcessor.h"
#include "DOMOvalXMLAnalyzer.h"
//#include "VariableCollector.h"
#include "Version.h"

#ifdef WIN32
	#include "windows/DataCollector.h"
	#define	DATACOLLECTOR DataCollector
	#define STRNICMP _strnicmp
	#include <windows.h>
#endif

#ifdef REDHAT
	#include "redhat/DataCollector.h"
	#define	DATACOLLECTOR DataCollector
	#define STRNICMP strnicmp
#endif

//	xerces include
#include <xercesc/dom/DOM.hpp>


//	other includes
#include <time.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

using namespace std;

#define BUFFER_SIZE 4096

// Local Function Definitions.

void Usage(string);


#endif
