//
// $Id: Common.h,v 1.3 2004/06/24 14:16:28 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  Common
//  author: Andrew Buttner
//  date:   11/19/2003
//
//  Functions that are common to many probe classes.,
//	Also used by main() for handling runtime configuration.
//
//****************************************************************************************//

#ifndef __COMMON_H__
#define __COMMON_H__

#ifdef WIN32
#pragma warning(disable:4786)
#endif

#include "Log.h"
#include "Exception.h"

#include <iostream>
#include <string>
#include <vector>
#include <time.h>
#include <sstream>

#ifdef WIN32
	#include <windows.h>
#else

#endif


using namespace std;

class Common
{
	public:
		static string	GetDatafile();
		static bool		GetGenerateMD5();
		static string	GetXMLfile();
		static string	GetXMLfileMD5();
		static string	GetOutputFilename();
		static bool		GetOutputToFile();
		static bool		GetSaveData();
		static string	GetStartTime();
		static bool		GetUseConfiguration();
		static bool		GetUseProvidedData();
		static bool		GetUseVariableFile();
		static bool		GetValidateXMLSchemas();
		static string	GetVariableFilename();
		static bool		GetVerifyXMLfile();

		static void		SetDataFile(string);
		static void		SetGenerateMD5(bool);
		static void		SetXMLfile(string);
		static void		SetXMLfileMD5(string);
		static void		SetOutputFilename(string);
		static void		SetOutputToFile(bool);
		static void		SetSaveData(bool);
		static void		SetStartTime(string);
		static void		SetUseConfiguration(bool);
		static void		SetUseProvidedData(bool);
		static void		SetUseVariableFile(bool);
		static void		SetValidateXMLSchemas(bool);
		static void		SetVariableFilename(string);
		static void		SetVerifyXMLfile(bool);


#ifdef WIN32
		static bool		DisableAllPrivileges();
		static bool		EnablePrivilege(string);
#endif
		static string	GetEnviromentVariable(string);
		static string	SwitchChar(string stringIn, string oldChr, string newChr);
		static string	ToString(int);
		static string	ToString(long);
		static string	ToString(unsigned long);

		static string	GetTimeStamp();

	private:
		static string dataFile;
		static string outputFilename;
		static string startTime;
		static string variablesFilename;
		static string xmlfile;
		static string xmlfileMD5;
		static bool	generateMD5;
		static bool outputToFile;
		static bool saveData;
		static bool useConfiguration;
		static bool useProvidedData;
		static bool useVariableFile;
		static bool validateXMLSchemas;
		static bool verifyXMLfile;
};

//	Define a vector for holding strings
typedef vector < string, allocator<string> > sVector;

class CommonException : public Exception
{
	public:
		CommonException();
		CommonException(string);
		~CommonException();
};


#endif
