-- [Schema]

CREATE TABLE Placeholder (Placeholder VARCHAR(32))
;
INSERT INTO Placeholder VALUES ('RedHat_3.0_DATESTAMP')
;

CREATE TABLE RedHat_FileAttributes
	(FilePath                               VARCHAR(4096), 
	FileType                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	Atime                                   INTEGER,
	Ctime                                   INTEGER,
	Mtime                                   INTEGER,
	MD5                                     VARCHAR(128),
	SUID                                    CHAR,
	SGID                                    CHAR,
	STICKY                                  CHAR,
	UREAD                                   CHAR,
	UWRITE                                  CHAR,
	UEXEC                                   CHAR,
	GREAD                                   CHAR,
	GWRITE                                  CHAR,
	GEXEC                                   CHAR,
	OREAD                                   CHAR,
	OWRITE                                  CHAR,
	OEXEC                                   CHAR)
;

CREATE TABLE RedHat_FileAttributes_Conf (FilePath VARCHAR(4096))
;

CREATE TABLE RedHat_InetListeningServers
	(Protocol                               VARCHAR(8),
	LocalFullAddress                        VARCHAR(128),
	LocalAddress                            VARCHAR(128),
	LocalPort                               INTEGER,
	ForeignFullAddress                      VARCHAR(128),
	ForeignAddress                          VARCHAR(128),
	ForeignPort                             INTEGER,
	UserID                                  INTEGER,
	PID                                     INTEGER,
	ProgramName                             VARCHAR(256))
;

CREATE TABLE RedHat_InetListeningServers_Conf (ProgramName VARCHAR(256))
;

CREATE TABLE RedHat_Passwd
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	GCOS                                    VARCHAR(256),
	HomeDir                                 VARCHAR(4096),
	LoginShell                              VARCHAR(4096))
;

-- No Conf table needed for password

CREATE TABLE RedHat_PSInfo
	(UserID                                 VARCHAR(128),
	PID                                     INTEGER,
	PPID                                    INTEGER,
	SchedulingClass                         VARCHAR(16),
	Priority                                INTEGER,
	StartTime                               VARCHAR(32),
	TTY                                     INTEGER,
	ExecTime                                VARCHAR(32),
	Command                                 VARCHAR(4096))
;

CREATE TABLE RedHat_PSInfo_Conf (Command VARCHAR(4096))
;
CREATE TABLE RedHat_RPMinfo
	(RPMName                                VARCHAR(256),
	RPMEpoch                                VARCHAR(8),
	RPMVersion                              VARCHAR(32),
	RPMRelease                              VARCHAR(32),
	RPMArch                                 VARCHAR(32))
;

CREATE TABLE RedHat_RPMinfo_Conf (RPMName VARCHAR(256))
;

CREATE TABLE RedHat_RPMVersionCompare
	(RPMName                                VARCHAR(256),
	RPMTestedEpoch                          VARCHAR(8),
	RPMTestedVersion                        VARCHAR(32),
	RPMTestedRelease                        VARCHAR(32),
	RPMInstalledVersion                     VARCHAR(16))
;

CREATE TABLE RedHat_RPMVersionCompare_Conf 
	(RPMName                                VARCHAR(256),
	RPMTestedEpoch                          VARCHAR(8),
	RPMTestedVersion                        VARCHAR(32),
	RPMTestedRelease                        VARCHAR(32))
;

CREATE TABLE RedHat_Shadow
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	ChgLst                                  INTEGER,
	ChgAllow                                INTEGER,
	ChgReq                                  INTEGER,
	ExpWarn                                 INTEGER,
	ExpInact                                INTEGER,
	ExpDate                                 INTEGER,
	PswFlag                                 VARCHAR(32))
;

-- No Conf table needed for shadow probe not implemented

CREATE TABLE RedHat_Uname
	(OSName                                 VARCHAR(32),
	NodeName                                VARCHAR(128),
	OSRelease                               VARCHAR(32),
	OSVersion                               VARCHAR(64),
	MachineClass                            VARCHAR(32),
	ProcessorType                           VARCHAR(32))
;
-- No Conf table needed for Uname

-- [Conf]
