#!/bin/bash

###############################################################################
# This wrapper script runs the query interpreter with good arguments.         #
#									      #
#   by Jay Beale, 5/2004, Copyright Mitre Corporation 			      #
###############################################################################

#
# Get a date of the start of the run, so we can date-stamp the resultant 
# database file.
#

DATE=`/bin/date +%F--%T`

#
# Next, run the query interpreter pointing it to the locations of the
# files it uses, placing results files in /var/log/ovalqi.
#

cd /var/log/ovalqi
/bin/touch /var/log/ovalqi/ovalqi-$DATE.slt
/usr/sbin/ovalqi -d /var/log/ovalqi/ovalqi-$DATE.slt \
		 -r /var/log/ovalqi/ovalqi-results-$DATE.html \
		 -o /usr/share/ovalqi/definitions.sql \
		 $1 $2		 

echo ...
echo Results-related files are stored in /var/log/ovalqi.
echo ...

