//
// $Id: FileAttributeData.h,v 1.2 2004/06/22 12:45:18 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	FileAttributeData.h
//  author: Jon Baker	
//  date:   30 January 2004
//
//	This class will store all data for a windows file. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//
//	TO DO:
//	Move all data to private data - This will effect the probe...
//
//
//****************************************************************************************//

#ifndef __FILEATTRIBUTEDATA_H__
#define __FILEATTRIBUTEDATA_H__

#include "../ProbeData.h"
//	Must include the registry probe to allow a file test to get a registry value 
//	and create a filepath.
#include "RegistryKeysProbe.h"

class FileAttributeData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	FileAttributeData(string, DBInterface*);
	FileAttributeData();
	~FileAttributeData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write(DBInterface*);

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------	
	TypedData *path;
	bool exists;
	string owner;
	string size;
	string a_time;
	string development_class;
	string c_time;
	string m_time;
	string ms_checksum;
	string md5;
	string majVer;
	string minVer;
	string buildVer;
	string priVer;
	string type;
	string msg;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	string GetEnvironmentVariable(string);
	void Parse(string);

	DBInterface *db;
};

#endif