//
// $Id: DataCollector.cpp,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter project.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// OVAL Query Interpreter; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//


#include "DataCollector.h"

//****************************************************************************************//
//								Probe Class												  //	
//****************************************************************************************//
DataCollector::DataCollector(DBInterface *dbIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the db pointer to be used by all probes.
	//
	// -----------------------------------------------------------------------
	db = dbIn;
}

DataCollector::~DataCollector()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now.
	//
	// -----------------------------------------------------------------------
	
}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void DataCollector::Run()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Simply call CreateProbeVectors() and RunProbes() method
	//
	// -----------------------------------------------------------------------

	string logMessage = " ** creating probe vectors\n";
	cout << logMessage;
	Log::WriteLog(logMessage);

	CreateProbeVectors();

	logMessage = " ** populating OVAL schema\n";
	Log::WriteLog(logMessage);
	cout << logMessage;

	RunProbes();
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//

void DataCollector::CreateProbeVectors()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Execute the needed sql statements to populate the probe vectors
	//
	// -----------------------------------------------------------------------

	string sqlSTMT;

	sqlSTMT = "";
	sqlSTMT.append("SELECT DISTINCT FilePath FROM ");
	sqlSTMT.append("Windows_FileEffectiveRights_Conf");
	
	db->ExecSQL(sqlSTMT, &vEffRights);

	sqlSTMT = "";
	sqlSTMT.append("SELECT DISTINCT FilePath FROM ");
	sqlSTMT.append("Windows_FileAttributes_Conf");

	db->ExecSQL(sqlSTMT, &vFileAtts);

	sqlSTMT = "";
	sqlSTMT.append("SELECT DISTINCT MetabaseKey FROM ");
	sqlSTMT.append("Windows_MetabaseKeys_Conf");

	db->ExecSQL(sqlSTMT, &vMetabaseKeys);

	sqlSTMT = "";
	sqlSTMT.append("SELECT DISTINCT RegistryKey FROM ");
	sqlSTMT.append("Windows_RegistryKeys_Conf");

	db->ExecSQL(sqlSTMT, &vRegKeys);

	sqlSTMT = "";
	sqlSTMT.append("SELECT DISTINCT RegistryKey FROM ");
	sqlSTMT.append("Windows_RegKeyEffectiveRights_Conf");

	db->ExecSQL(sqlSTMT, &vRegKeyEffRights);
}

void DataCollector::RunProbes()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Run all probes usingthe probe vectors to provide data input for 
	//	the probes.
	//
	// -----------------------------------------------------------------------

	ProbeData *myProbeData = NULL;
	pdVector pdResultVector;

	AccountPrivileges* ptrAP = new AccountPrivileges("Windows_", db);
	(*ptrAP).Run();
	delete ptrAP;
	ptrAP = NULL;

	//	For each item in the vFileAtts creat a new FileAttributeData
	//	object. Then call the FileAttributesProbee. For each data
	//	object returned by the probe call its write() method.
	FileAttributesProbe *myFileAttsProbe = new FileAttributesProbe();
	stringVector::iterator fpIt;

	for (fpIt=this->vFileAtts.begin(); fpIt!=this->vFileAtts.end(); fpIt++)
    {
		myProbeData = new FileAttributeData((*fpIt), db);

		pdResultVector = myFileAttsProbe->Run(myProbeData);

		ProbeData *tmp	= NULL;
		while(pdResultVector.size() !=0)
		{
			tmp = pdResultVector[pdResultVector.size()-1];
			tmp->Write(db);
			pdResultVector.pop_back();
			delete tmp;
			tmp = NULL;
		}

		delete myProbeData;
		myProbeData = NULL;
	}
	delete myFileAttsProbe;
	myFileAttsProbe = NULL;

	FileEffectiveRights* ptrER = new FileEffectiveRights("Windows_", this->vEffRights, db);
	(*ptrER).Run();
	delete ptrER;
	ptrER = NULL;

	//	For each item in the vMetabaseKeys create a new MetabaseKeyData
	//	object. Then call the MetabaseKeysProbe. For each data
	//	object returned by the probe call its write() method.
	MetabaseKeysProbe *myMBKeysProbe = new MetabaseKeysProbe();
	stringVector::iterator mbKIt;

	for (mbKIt=this->vMetabaseKeys.begin(); mbKIt!=this->vMetabaseKeys.end(); mbKIt++)
    {
		myProbeData = new MetabaseKeyData((*mbKIt));

		pdResultVector = myMBKeysProbe->Run(myProbeData);

		ProbeData *tmp	= NULL;
		while(pdResultVector.size() !=0)
		{
			tmp = pdResultVector[pdResultVector.size()-1];
			tmp->Write(db);
			pdResultVector.pop_back();
			delete tmp;
			tmp = NULL;
		}

		delete myProbeData;
		myProbeData = NULL;
	}
	delete myMBKeysProbe;
	myMBKeysProbe = NULL;

	PSInfo* ptrPS = new PSInfo("Windows_", db);
	(*ptrPS).Run();
	delete ptrPS;
	ptrPS = NULL;


	//	For each item in the vRegKeys creat a new RegistryKeyData
	//	object. Then call the RegistryKeysProbe. For each data
	//	object returned by the probe call its write() method.
	RegistryKeysProbe *myRegKeyProbe = new RegistryKeysProbe();
	stringVector::iterator rkIt;

	for (rkIt=this->vRegKeys.begin(); rkIt!=this->vRegKeys.end(); rkIt++)
    {
		myProbeData = new RegistryKeyData((*rkIt));

		pdResultVector = myRegKeyProbe->Run(myProbeData);

		ProbeData *tmp	= NULL;
		while(pdResultVector.size() !=0)
		{
			tmp = pdResultVector[pdResultVector.size()-1];
			tmp->Write(db);
			pdResultVector.pop_back();
			delete tmp;
			tmp = NULL;
		}

		delete myProbeData;
		myProbeData = NULL;
	}
	delete myRegKeyProbe;
	myRegKeyProbe = NULL;


	RegKeyEffectiveRights* ptrRE = new RegKeyEffectiveRights("Windows_", this->vRegKeyEffRights, db);
	(*ptrRE).Run();
	delete ptrRE;
	ptrRE = NULL;
	
}