//
// $Id: RPMVersionCompareData.cpp,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	RPMVersionCompareData.cpp
//  author: Jon Baker	
//  date:   11 Februauy 2004
//
//	This calss will store all data for a RPMVersionCompare test. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "RPMVersionCompareData.h"

//****************************************************************************************//
//								RPMVersionCompareData Class								  //	
//****************************************************************************************//
RPMVersionCompareData::RPMVersionCompareData(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RPMVersionCompareData and populate with the node's data
	// -----------------------------------------------------------------------

	string testName;

	//	Validate the test node
	if(test->getNodeType() != DOMNode::ELEMENT_NODE )
	{
		throw ProbeDataException("Error: RPMVersionCompareData() Invalid test node type specified. Only ELEMENT_NODE's are allowed.");
	}else
	{
		testName = DOMCommon::ToString(test->getNodeName());
		if(testName.compare("rpmversioncompare_test") != 0)
			throw ProbeDataException("Error: RPMVersionCompareData() Invalid test node specified. Received: " + testName);
	}

	//	Init the data members
	testId = "";
	name = new TypedData(LITTERAL_TYPE, "");
	tested_epoch = "";
	tested_version = "";
	tested_release = "";
	installed_version = "";
	msg = "";

	//	Call the parse node function
	ParseNode(test);
}

RPMVersionCompareData::RPMVersionCompareData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RPMVersionCompareData as an empty object.
	// -----------------------------------------------------------------------
	testId = "";
	name = new TypedData(LITTERAL_TYPE, "");
	tested_epoch = "";
	tested_version = "";
	tested_release = "";
	installed_version = "";
	msg = "";
}

RPMVersionCompareData::~RPMVersionCompareData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void RPMVersionCompareData::Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a new rpmversioncompare_test node and add it to the dataDocument.
	//	
	// -----------------------------------------------------------------------

	//	Create a new test node
	DOMElement *rpmversioncompare_test = CreateNewTestNode(dataDocument, "rpmversioncompare_test");

	//	Add the name element - as a string
	AddChildNode(dataDocument, rpmversioncompare_test, "name", name->data);	

	//	Add the tested_epoch element - as a string
	AddChildNode(dataDocument, rpmversioncompare_test, "tested_epoch", tested_epoch);

	//	Add the tested_version element - as a string
	AddChildNode(dataDocument, rpmversioncompare_test, "tested_version", tested_version);
	
	//	Add the tested_release element - as a string
	AddChildNode(dataDocument, rpmversioncompare_test, "tested_release", tested_release);

	//	Add the installed_version element - as a string
	AddChildNode(dataDocument, rpmversioncompare_test, "installed_version", installed_version);

	//	Add the message element - as a string
	AddChildNode(dataDocument, rpmversioncompare_test, "message", msg);

}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void RPMVersionCompareData::ParseNode(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to popular this RPMVersionCompareData
	//	Really just need to gather the Test id.
	// -----------------------------------------------------------------------

	///////////////////////////////////////////////////////////////////////////
	//	Get the test id
	///////////////////////////////////////////////////////////////////////////
	testId = DOMCommon::GetAttributeByName(test, "id");
	if(testId.compare("") == 0)
		throw ProbeDataException("Error: Unable to find the 'id' attribute for a RPM Version Compare test.");	
 

	///////////////////////////////////////////////////////////////////////////
	//	Gather the data needed to call the probe
	///////////////////////////////////////////////////////////////////////////
	string childName	= "";
	string childOp		= "";
	
	DOMNode *rpmversioncompareChild;
	DOMNodeList *rpmversioncompareChildList;

	//	get a list of the child nodes and their values
	rpmversioncompareChildList = test->getChildNodes();
	unsigned int index = 0;
	while(index < rpmversioncompareChildList->getLength())
	{
		rpmversioncompareChild = rpmversioncompareChildList->item(index);

		//	only concerned with ELEMENT_NODEs
		if (rpmversioncompareChild->getNodeType() == DOMNode::ELEMENT_NODE)
		{
			//	get the name of the child
			childName = DOMCommon::ToString(rpmversioncompareChild->getNodeName());

			//	Get the child's operator
			childOp = DOMCommon::GetAttributeByName(rpmversioncompareChild, "operator");
			
			//	Get the name value - must support pattern matching on name only	
			if(strncmp(childName.c_str(), "name", 4)==0)
			{
				if(childOp.compare("pattern match") == 0)
				  name->type = PATTERN_MATCH_TYPE;
				else
				  name->type = LITTERAL_TYPE;

				name->data = DOMCommon::GetDataNodeValue(rpmversioncompareChild);
				
			//	Get the tested_epoch value
			}else if(strncmp(childName.c_str(), "tested_epoch", 11)==0)
			{
				tested_epoch = DOMCommon::GetDataNodeValue(rpmversioncompareChild);
			
			//	Get the tested_version value
			}else if(strncmp(childName.c_str(), "tested_version", 13)==0)
			{
				tested_version = DOMCommon::GetDataNodeValue(rpmversioncompareChild);
		       
			//	Get the tested_release value
			}else if(strncmp(childName.c_str(), "tested_release", 13)==0)
			{
				tested_release = DOMCommon::GetDataNodeValue(rpmversioncompareChild);
			}
		}
		index ++;
	}
}
