//
// $Id: InetListeningServersData.h,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	InetListeningServersData.h
//  author: Jon Baker	
//  date:   4 March 2004
//
//	This class will store all data for a red hat inet listening servers test.
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//
//	TO DO:
//	Move all data to private data - This will effect the probe...
//
//****************************************************************************************//

#ifndef __INETLISTENINGSERVERSDATA_H_
#define __INETLISTENINGSERVERSDATA_H_

#include "ProbeData.h"

class InetListeningServersData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	InetListeningServersData(DOMNode *test);
	InetListeningServersData();
	~InetListeningServersData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument);

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------
	TypedData *program_name;
	string local_full_address;
	string local_address;
	string local_port;
	string foreign_full_address;
	string foreign_address;
	string foreign_port;
	string user_id;
	string pid;
	string protocol;
	string msg;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMNode *test);
};

#endif
