//
// $Id: DOMOvalResultXML.h,v 1.3 2004/07/08 15:31:56 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DOMOvalResultXML
//  author: Jon Baker	
//  date:   2 March 2004
//
//	This class is responsible for the creating, storing, and maintaing 
//	the system_assessment file.
//
//****************************************************************************************//

#ifndef __DOMOVALRESULTXML_H__
#define __DOMOVALRESULTXML_H__


//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>

#include "Common.h"
#include "Exception.h"
#include "DOMCommon.h"
#include "DOMProcessor.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	define constants to represent test results
#define UNKNOWN_TEST_RESULT -1
#define FALSE_TEST_RESULT 0
#define TRUE_TEST_RESULT 1

class DOMOvalResultXML  
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	DOMOvalResultXML(DOMProcessor*, string);
	virtual ~DOMOvalResultXML();
	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void AddCompoundTest(DOMElement*);
	void AddDefinition(DOMElement*);
	void AddHostInfo(string hostName, string ip);
	void AddTest(DOMElement*);
	void AddTimeStamps(DOMElement*, string);
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* GetResultFile();


private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void AddCriterion(DOMElement*, DOMElement*);
	void AddSubtest(DOMElement*, DOMElement*);
	DOMElement* CreateNodeWithValue(DOMElement*, string, string);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *resultDocument; 
	string familyXMLNS;
	string familyXMLNSQualifier;
	string xsiSchemaLocation;
	string family;
};

//	Define a ProbeException
class DOMOvalResultXMLException : public Exception
{
	public:

		DOMOvalResultXMLException();
		DOMOvalResultXMLException(string errorMessageIn);
		~DOMOvalResultXMLException();
};

#endif
