-- [Schema]

CREATE TABLE Placeholder (Placeholder VARCHAR(32))
;
INSERT INTO Placeholder VALUES ('Solaris_3.0_DATESTAMP')
;

CREATE TABLE Solaris_FileAttributes
	(FilePath                               VARCHAR(4096), 
	FileType                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	Atime                                   INTEGER,
	Ctime                                   INTEGER,
	Mtime                                   INTEGER,
	MD5                                     VARCHAR(128),
	SUID                                    CHAR,
	SGID                                    CHAR,
	STICKY                                  CHAR,
	UREAD                                   CHAR,
	UWRITE                                  CHAR,
	UEXEC                                   CHAR,
	GREAD                                   CHAR,
	GWRITE                                  CHAR,
	GEXEC                                   CHAR,
	OREAD                                   CHAR,
	OWRITE                                  CHAR,
	OEXEC                                   CHAR)
;

CREATE TABLE Solaris_FileAttributes_Conf (FilePath VARCHAR(4096))
;

CREATE TABLE Solaris_InetdConf
	(ServiceName                           VARCHAR(128),
	EndpointType                           VARCHAR(32),
	Protocol                               VARCHAR(32),
	WaitStatus                             VARCHAR(32),
	ExecAsUser                             VARCHAR(32),
	ServerProgram                          VARCHAR(1024),
	ServerArguments                        VARCHAR(512))
;

CREATE TABLE Solaris_InetdConf_Conf (ServerProgram VARCHAR(1024))
;

CREATE TABLE Solaris_Patches
	(PatchBase                             INTEGER,
	PatchVersion                           INTEGER)
;

CREATE TABLE Solaris_Patches_Conf (PatchBase INTEGER)
;

CREATE TABLE Solaris_Pkginfo
	(Pkginst                                VARCHAR(64),
	Name                                    VARCHAR(1024),
	Category                                VARCHAR(32),
	Version                                 VARCHAR(32),
	Vendor                                  VARCHAR(256),
	Description                             VARCHAR(1024))
;

CREATE TABLE Solaris_Pkginfo_Conf (Pkginst VARCHAR(64))
;

CREATE TABLE Solaris_PSInfo 
	(UserID                                 VARCHAR(128),
	PID                                     INTEGER,
	PPID                                    INTEGER,
	SchedulingClass                         VARCHAR(16),
	Priority                                INTEGER,
	StartTime                               VARCHAR(32),
	TTY                                     INTEGER,
	ExecTime                                VARCHAR(32),
	Command                                 VARCHAR(4096))
;

CREATE TABLE Solaris_PSInfo_Conf (Command VARCHAR(4096))
;

CREATE TABLE Solaris_Passwd
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	GCOS                                    VARCHAR(256),
	HomeDir                                 VARCHAR(1024),
	LoginShell                              VARCHAR(1024))
;

CREATE TABLE Solaris_Passwd_Conf (Username VARCHAR(128))
;

CREATE TABLE Solaris_Shadow
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	ChgLst                                  INTEGER,
	ChgAllow                                INTEGER,
	ChgReq                                  INTEGER,
	ExpWarn                                 INTEGER,
	ExpInact                                INTEGER,
	ExpDate                                 INTEGER,
	PswFlag                                 VARCHAR(32))
;

CREATE TABLE Solaris_Shadow_Conf (Username VARCHAR(128))
;

CREATE TABLE Solaris_Uname
	(OSName                                 VARCHAR(32),
	NodeName                                VARCHAR(128),
	OSRelease                               VARCHAR(32),
	OSVersion                               VARCHAR(64),
	MachineClass                            VARCHAR(32),
	ProcessorType                           VARCHAR(32)
	HardwarePlatform                        VARCHAR(64))
;

-- No Conf table needed for Uname

-- [Conf]