<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<sch:title>schematron validation for an OVAL Results file</sch:title>
	<sch:title xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5">schematron validation of the Core portion of an OVAL Results file</sch:title>
	<sch:title xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Core portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5">schematron validation of the Core portion of an OVAL System Characteristics file</sch:title>
	<sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance" />
	<sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5" />
	<sch:ns prefix="oval-res" uri="http://oval.mitre.org/XMLSchema/oval-results-5" />
	<sch:ns prefix="oval-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" />
	<sch:ns prefix="oval-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5" />
	<sch:pattern id="directives" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5">
		<sch:rule context="oval-res:definition[@result='true' and oval-res:criteria]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='true' and not(oval-res:criteria)]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should not be included (see directives) xx</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='false' and oval-res:criteria]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full'">
				<value-of select="@definition_id" /> - definitions with a result of FALSE should contain THIN content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='false' and not(oval-res:criteria)]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin'">
				<value-of select="@definition_id" /> - definitions with a result of FALSE should contain FULL content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='unknown' and oval-res:criteria]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='unknown' and not(oval-res:criteria)]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='error' and oval-res:criteria]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='error' and not(oval-res:criteria)]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='not evaluated' and oval-res:criteria]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='not evaluated' and not(oval-res:criteria)]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='not applicable' and oval-res:criteria]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
		</sch:rule>
		<sch:rule context="oval-res:definition[@result='not applicable' and not(oval-res:criteria)]">
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
				<value-of select="@definition_id" /> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
			<sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">
				<value-of select="@definition_id" /> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="directives" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5">
		<sch:rule context="oval-res:test">
			<sch:assert test="@test_id = ../../oval-res:definitions//oval-res:criterion/@test_ref">
				<value-of select="@test_id" /> - the specific test is not used in any definition's criteria</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="entityvarref" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="oval-def:objects/*/*|oval-def:states/*/*">
			<sch:assert test="not(@var_ref) or .=''">
				<value-of select="../@id" /> - a var-ref has been supplied for the <value-of select="name()" /> entity so no value should be provided</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="entitystatus" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5">
		<sch:rule context="oval-sc:system_data/*/*">
			<sch:assert test="@status='exists' or .=''">item <value-of select="../@id" /> - a value for the <value-of select="name()" /> entity should only be supplied if the status attribute is 'exists'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:diagnostics />
</sch:schema>
