<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron"
            xmlns:xsd="http://www.w3.org/2001/XMLSchema"
            queryBinding="xslt">
   <sch:title>Schematron validation for an OVAL Results file</sch:title>
   <sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>
   <sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5"/>
   <sch:ns prefix="oval-res" uri="http://oval.mitre.org/XMLSchema/oval-results-5"/>
   <sch:ns prefix="oval-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5"/>
   <sch:ns prefix="oval-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"/>
   <sch:ns xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5"
           xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
           xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
           xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
           prefix="ind-def"
           uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"/>
   <sch:phase id="oval">
      <sch:active pattern="oval_none_exist_value_dep"/>
   </sch:phase>
   <sch:phase id="oval-res">
      <sch:active pattern="oval-res_system"/>
      <sch:active pattern="oval-res_directives"/>
      <sch:active pattern="oval-res_testids"/>
   </sch:phase>
   <sch:phase id="oval-def">
      <sch:active pattern="oval-def_empty_def_doc"/>
      <sch:active pattern="oval-def_required_criteria"/>
      <sch:active pattern="oval-def_test_type"/>
      <sch:active pattern="oval-def_setobjref"/>
      <sch:active pattern="oval-def_allowed-variable-datatypes"/>
      <sch:active pattern="oval-def_literal_component"/>
      <sch:active pattern="oval-def_arithmeticfunctionrules"/>
      <sch:active pattern="oval-def_beginfunctionrules"/>
      <sch:active pattern="oval-def_concatfunctionrules"/>
      <sch:active pattern="oval-def_endfunctionrules"/>
      <sch:active pattern="oval-def_escaperegexfunctionrules"/>
      <sch:active pattern="oval-def_splitfunctionrules"/>
      <sch:active pattern="oval-def_substringfunctionrules"/>
      <sch:active pattern="oval-def_timedifferencefunctionrules"/>
      <sch:active pattern="oval-def_regexcapturefunctionrules"/>
      <sch:active pattern="oval-def_definition_entity_rules"/>
      <sch:active pattern="oval-def_no_var_ref_with_records"/>
      <sch:active pattern="oval-def_definition_entity_type_check_rules"/>
      <sch:active pattern="oval-def_entityobjectbaserules"/>
      <sch:active pattern="oval-def_entitystatebaserules"/>
      <sch:active pattern="oval-def_state_record_fields"/>
   </sch:phase>
   <sch:phase id="oval-sc">
      <sch:active pattern="oval-sc_entity_rules"/>
      <sch:active pattern="oval-sc_item_record_fields"/>
   </sch:phase>
   <sch:phase id="ind-def">
      <sch:active pattern="ind-def_famtst"/>
      <sch:active pattern="ind-def_famstefamily"/>
      <sch:active pattern="ind-def_hashtst"/>
      <sch:active pattern="ind-def_hashobjfilepath"/>
      <sch:active pattern="ind-def_hashobjpath"/>
      <sch:active pattern="ind-def_hashobjfilename"/>
      <sch:active pattern="ind-def_hashstefilepath"/>
      <sch:active pattern="ind-def_hashstepath"/>
      <sch:active pattern="ind-def_hashstefilename"/>
      <sch:active pattern="ind-def_hashstemd5"/>
      <sch:active pattern="ind-def_hashstesha1"/>
      <sch:active pattern="ind-def_envtst"/>
      <sch:active pattern="ind-def_envobjname"/>
      <sch:active pattern="ind-def_envstename"/>
      <sch:active pattern="ind-def_envstevalue"/>
      <sch:active pattern="ind-def_ldap_test_dep"/>
      <sch:active pattern="ind-def_ldaptst"/>
      <sch:active pattern="ind-def_ldap_object_dep"/>
      <sch:active pattern="ind-def_ldapobjsuffix"/>
      <sch:active pattern="ind-def_ldapobjrelative_dn"/>
      <sch:active pattern="ind-def_ldapobjattribute"/>
      <sch:active pattern="ind-def_ldap_state_dep"/>
      <sch:active pattern="ind-def_ldapstesuffix"/>
      <sch:active pattern="ind-def_ldapsterelative_dn"/>
      <sch:active pattern="ind-def_ldapsteattribute"/>
      <sch:active pattern="ind-def_ldapsteobject_class"/>
      <sch:active pattern="ind-def_ldapsteldaptype"/>
      <sch:active pattern="ind-def_ldapsteldapvalue"/>
      <sch:active pattern="ind-def_ldap57_test"/>
      <sch:active pattern="ind-def_ldap57_object_suffix"/>
      <sch:active pattern="ind-def_ldap57_object_relative_dn"/>
      <sch:active pattern="ind-def_ldap57_object_attribute"/>
      <sch:active pattern="ind-def_ldap57_state_suffix"/>
      <sch:active pattern="ind-def_ldap57_state_relative_dn"/>
      <sch:active pattern="ind-def_ldap57_state_attribute"/>
      <sch:active pattern="ind-def_ldap57_state_object_class"/>
      <sch:active pattern="ind-def_ldap57_state_ldaptype"/>
      <sch:active pattern="ind-def_ldap57_state_value"/>
      <sch:active pattern="ind-def_sql_test_dep"/>
      <sch:active pattern="ind-def_sqltst"/>
      <sch:active pattern="ind-def_sql_object_dep"/>
      <sch:active pattern="ind-def_sqlobjdengine"/>
      <sch:active pattern="ind-def_sqlobjversion"/>
      <sch:active pattern="ind-def_sqlobjconnection_string"/>
      <sch:active pattern="ind-def_sqlobjsql"/>
      <sch:active pattern="ind-def_sql_state_dep"/>
      <sch:active pattern="ind-def_sqlsteengine"/>
      <sch:active pattern="ind-def_sqlsteversion"/>
      <sch:active pattern="ind-def_sqlsteconnection_string"/>
      <sch:active pattern="ind-def_sqlstesql"/>
      <sch:active pattern="ind-def_sqlsteresult"/>
      <sch:active pattern="ind-def_sql57_test"/>
      <sch:active pattern="ind-def_sql57_object_dengine"/>
      <sch:active pattern="ind-def_sql57_object_version"/>
      <sch:active pattern="ind-def_sql57_object_connection_string"/>
      <sch:active pattern="ind-def_sql57_object_sql"/>
      <sch:active pattern="ind-def_sql57_state_engine"/>
      <sch:active pattern="ind-def_sql57_state_version"/>
      <sch:active pattern="ind-def_sql57_state_connection_string"/>
      <sch:active pattern="ind-def_sql57_state_sql"/>
      <sch:active pattern="ind-def_sql57_state_result"/>
      <sch:active pattern="ind-def_txt54tst"/>
      <sch:active pattern="ind-def_txt54objfilepath"/>
      <sch:active pattern="ind-def_txt54objpath"/>
      <sch:active pattern="ind-def_txt54objfilename"/>
      <sch:active pattern="ind-def_txt54objpattern"/>
      <sch:active pattern="ind-def_txt54objinstance"/>
      <sch:active pattern="ind-def_txt54stefilepath"/>
      <sch:active pattern="ind-def_txt54stepath"/>
      <sch:active pattern="ind-def_txt54stefilename"/>
      <sch:active pattern="ind-def_txt54stepattern"/>
      <sch:active pattern="ind-def_txt54steinstance"/>
      <sch:active pattern="ind-def_txt54stetext"/>
      <sch:active pattern="ind-def_txt54stesubexpression"/>
      <sch:active pattern="ind-def_txttst_dep"/>
      <sch:active pattern="ind-def_txttst"/>
      <sch:active pattern="ind-def_txtobj_dep"/>
      <sch:active pattern="ind-def_txtobjpath"/>
      <sch:active pattern="ind-def_txtobjfilename"/>
      <sch:active pattern="ind-def_txtobjline"/>
      <sch:active pattern="ind-def_txtste_dep"/>
      <sch:active pattern="ind-def_txtstepath"/>
      <sch:active pattern="ind-def_txtstefilename"/>
      <sch:active pattern="ind-def_txtsteline"/>
      <sch:active pattern="ind-def_txtstesubexpression"/>
      <sch:active pattern="ind-def_vattst"/>
      <sch:active pattern="ind-def_varobjvar_ref"/>
      <sch:active pattern="ind-def_varstevar_ref"/>
      <sch:active pattern="ind-def_xmltst"/>
      <sch:active pattern="ind-def_xmlobjfilepath"/>
      <sch:active pattern="ind-def_xmlobjpath"/>
      <sch:active pattern="ind-def_xmlobjfilename"/>
      <sch:active pattern="ind-def_xmlobjxpath"/>
      <sch:active pattern="ind-def_xmlfilestefilepath"/>
      <sch:active pattern="ind-def_xmlstepath"/>
      <sch:active pattern="ind-def_xmlstefilename"/>
      <sch:active pattern="ind-def_xmlstexpath"/>
      <sch:active pattern="ind-def_xmlstevalue_of"/>
      <sch:active pattern="ind-def_ldaptype_timestamp_value_dep"/>
      <sch:active pattern="ind-def_ldaptype_email_value_dep"/>
   </sch:phase>
   <sch:pattern id="oval_none_exist_value_dep">
                                   <sch:rule context="oval-def:oval_definitions/oval-def:tests/child::*">
                                        <sch:report test="@check='none exist'">
                                             DEPRECATED ATTRIBUTE VALUE IN: <sch:value-of select="name()"/> ATTRIBUTE VALUE:
                                        </sch:report>
                                   </sch:rule>
                              </sch:pattern>
   <sch:pattern id="oval-res_system">
                         <sch:rule context="oval-res:system[oval-res:tests]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">the tests element should not be included unless full results are to be provided (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:system[not(oval-res:tests)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">the tests element should be included when full results are specified (see directives)</sch:assert>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="oval-res_directives">
                         <sch:rule context="oval-res:definition[@result='true' and oval-res:criteria]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should not be included (see directives)</sch:assert>
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full'">
            <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='true' and not(oval-res:criteria)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should not be included (see directives) xx</sch:assert>
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin'">
            <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='false' and oval-res:criteria]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full'">
            <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should contain THIN content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='false' and not(oval-res:criteria)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin'">
            <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should contain FULL content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='unknown' and oval-res:criteria]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full'">
            <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should contain THIN content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='unknown' and not(oval-res:criteria)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin'">
            <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should contain FULL content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='error' and oval-res:criteria]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full'">
            <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should contain THIN content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='error' and not(oval-res:criteria)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin'">
            <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should contain FULL content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='not evaluated' and oval-res:criteria]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should contain THIN content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='not evaluated' and not(oval-res:criteria)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should contain FULL content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='not applicable' and oval-res:criteria]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should contain THIN content (see directives)</sch:assert>
                         </sch:rule>
                         <sch:rule context="oval-res:definition[@result='not applicable' and not(oval-res:criteria)]">
                              <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
                               <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">
            <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should contain FULL content (see directives)</sch:assert>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="oval-res_testids">
                         <sch:rule context="oval-res:test">
                              <sch:assert test="@test_id = ../../oval-res:definitions//oval-res:criterion/@test_ref">
            <sch:value-of select="@test_id"/> - the specified test is not used in any definition's criteria</sch:assert>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="oval-def_empty_def_doc">
                    <sch:rule context="oval-def:oval_definitions">
                        <sch:assert test="oval-def:definitions or oval-def:tests or oval-def:objects or oval-def:states or oval-def:variables">A valid OVAL Definition document must contain at least one definitions, tests, objects, states, or variables element. The optional definitions, tests, objects, states, and variables sections define the specific characteristics that should be evaluated on a system to determine the truth values of the OVAL Definition Document. To be valid though, at least one definitions, tests, objects, states, or variables element must be present.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_required_criteria">
                    <sch:rule context="oval-def:oval_definitions/oval-def:definitions/oval-def:definition[@deprecated='false' or not(@deprecated)]">
                        <sch:assert test="oval-def:criteria">A valid OVAL Definition document must contain a criteria unless the definition is a deprecated definition.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_test_type">
                    <sch:rule context="oval-def:oval_definitions/oval-def:tests/*[@check_existence='none_exist']">
                        <sch:assert test="not(*[local-name()='state'])">
            <sch:value-of select="@id"/> - No state should be referenced when check_existence has a value of 'none_exist'.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_setobjref">
                    <sch:rule context="oval-def:oval_definitions/oval-def:objects/*/oval-def:set/oval-def:object_reference">
                        <sch:assert test="name(./../..) = name(ancestor::oval-def:oval_definitions/oval-def:objects/*[@id=current()])">
            <sch:value-of select="../../@id"/> - Each object referenced by the set must be of the same type as parent object</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:oval_definitions/oval-def:objects/*/oval-def:set/oval-def:set/oval-def:object_reference">
                        <sch:assert test="name(./../../..) = name(ancestor::oval-def:oval_definitions/oval-def:objects/*[@id=current()])">
            <sch:value-of select="../../../@id"/> - Each object referenced by the set must be of the same type as parent object</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:oval_definitions/oval-def:objects/*/oval-def:set/oval-def:set/oval-def:set/oval-def:object_reference">
                        <sch:assert test="name(./../../../..) = name(ancestor::oval-def:oval_definitions/oval-def:objects/*[@id=current()])">
            <sch:value-of select="../../../../@id"/> - Each object referenced by the set must be of the same type as parent object</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_allowed-variable-datatypes">
                    <sch:rule context="oval-def:variables/child::*">
                        <sch:assert test="not(@datatype='record')">
            <sch:value-of select="@id"/> - The 'record' datatype is prohibited on variables.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_literal_component">
                    <sch:rule context="oval-def:literal_component">
                        <sch:assert test="not(@datatype='record')">
            <sch:value-of select="ancestor::*/@id"/> - The 'record' datatype is prohibited on variables.</sch:assert>
                    </sch:rule>
                    <!--
                        <sch:rule context="oval-def:literal_component/*/*[not(@datatype)]">
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='binary']">
                        <sch:assert test="matches(., '^[0-9a-fA-F]*$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of binary.</sch:assert>
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='boolean']">
                        <sch:assert test="matches(., '^true$|^false$|^1$|^0$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of boolean.</sch:assert>
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='evr_string']">
                        <sch:assert test="matches(., '^[^:\-]*:[^:\-]*-[^:\-]*$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of evr_string.</sch:assert>
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='fileset_revision']">
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='float']">
                        <sch:assert test="matches(., '^[+\-]?[0-9]+([\.][0-9]+)?([eE][+\-]?[0-9]+)?$|^NaN$|^INF$|^\-INF$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of float.</sch:assert>
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='ios_version']">
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='int']">
                        <sch:assert test="matches(., '^[+\-]?[0-9]+$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of int.</sch:assert>
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='string']">
                        </sch:rule>
                        <sch:rule context="oval-def:literal_component[@datatype='version']">
                        </sch:rule>
                    -->
                </sch:pattern>
   <sch:pattern id="oval-def_arithmeticfunctionrules">
                    <sch:rule context="oval-def:arithmetic/oval-def:literal_component">
                        <sch:assert test="@datatype='float' or @datatype='int'">A literal_component used by an arithmetic function must have a datatype of float or int.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:arithmetic/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype='float' or ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype='int'">The variable referenced by the arithmetic function must have a datatype of float or int.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_beginfunctionrules">
                    <sch:rule context="oval-def:begin/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the begin function must have a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:begin/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the begin function must have a datatype of string.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_concatfunctionrules">
                        <sch:rule context="oval-def:concat/oval-def:literal_component">
                            <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the concat function must have a datatype of string.</sch:assert>
                        </sch:rule>
                        <sch:rule context="oval-def:concat/oval-def:variable_component">
                            <sch:let name="var_ref" value="@var_ref"/>
                            <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the concat function must have a datatype of string.</sch:assert>
                        </sch:rule>
                    </sch:pattern>
   <sch:pattern id="oval-def_endfunctionrules">
                    <sch:rule context="oval-def:end/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the end function must have a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:end/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the end function must have a datatype of string.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_escaperegexfunctionrules">
                    <sch:rule context="oval-def:escape_regex/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the escape_regex function must have a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:escape_regex/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the escape_regex function must have a datatype of string.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_splitfunctionrules">
                    <sch:rule context="oval-def:split/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the split function must have a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:split/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the split function must have a datatype of string.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_substringfunctionrules">
                    <sch:rule context="oval-def:substring/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the substring function must have a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:substring/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the substring function must have a datatype of string.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_timedifferencefunctionrules">
                    <sch:rule context="oval-def:time_difference/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string' or @datatype='int'">A literal_component used by the time_difference function must have a datatype of string or int.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:time_difference/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype='string' or ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype='int'">The variable referenced by the time_difference function must have a datatype of string or int.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_regexcapturefunctionrules">
                    <sch:rule context="oval-def:regex_capture/oval-def:literal_component">
                        <sch:assert test="not(@datatype) or @datatype='string'">A literal_component used by the regex_capture function must have a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:regex_capture/oval-def:variable_component">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test="ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype = 'string'">The variable referenced by the regex_capture function must have a datatype of string.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_definition_entity_rules">
                    <sch:rule context="oval-def:objects/*/*[@var_ref]|oval-def:states/*/*[@var_ref]|oval-def:states/*/*/*[@var_ref]">
                        <sch:let name="var_ref" value="@var_ref"/>
                        <sch:assert test=".=''">
            <sch:value-of select="../@id"/> - a var_ref has been supplied for the <sch:value-of select="name()"/> entity so no value should be provided</sch:assert>
                        <sch:assert test="( (not(@datatype)) and ('string' = ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype) ) or (@datatype = ancestor::oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype)">
            <sch:value-of select="$var_ref"/> - inconsistent datatype between the variable and an associated var_ref</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[not(@datatype)]|oval-def:states/*/*[not(@datatype)]|oval-def:states/*/*/*[not(@datatype)]">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='case insensitive equals' or @operation='case insensitive not equal' or @operation='pattern match'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given the lack of a declared datatype (hence a default datatype of string).</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='binary']|oval-def:states/*/*[@datatype='binary']|oval-def:states/*/*/*[@datatype='binary']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of binary.</sch:assert>
                        <!--<sch:assert test="matches(., '^[0-9a-fA-F]*$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of binary.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='boolean']|oval-def:states/*/*[@datatype='boolean']|oval-def:states/*/*/*[@datatype='boolean']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of boolean.</sch:assert>
                        <!--<sch:assert test="matches(., '^true$|^false$|^1$|^0$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of boolean.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='evr_string']|oval-def:states/*/*[@datatype='evr_string']|oval-def:states/*/*/*[@datatype='evr_string']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or  @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of evr_string.</sch:assert>
                        <!--<sch:assert test="matches(., '^[^:\-]*:[^:\-]*-[^:\-]*$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of evr_string.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='fileset_revision']|oval-def:states/*/*[@datatype='fileset_revision']|oval-def:states/*/*/*[@datatype='fileset_revision']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or  @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of fileset_revision.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='float']|oval-def:states/*/*[@datatype='float']|oval-def:states/*/*/*[@datatype='float']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of float.</sch:assert>
                        <!--<sch:assert test="matches(., '^[+\-]?[0-9]+([\.][0-9]+)?([eE][+\-]?[0-9]+)?$|^NaN$|^INF$|^\-INF$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of float.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='ios_version']|oval-def:states/*/*[@datatype='ios_version']|oval-def:states/*/*/*[@datatype='ios_version']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of ios_version.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='int']|oval-def:states/*/*[@datatype='int']|oval-def:states/*/*/*[@datatype='int']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of int.</sch:assert>
                        <!--<sch:assert test="matches(., '^[+\-]?[0-9]+$')"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of int.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='string']|oval-def:states/*/*[@datatype='string']|oval-def:states/*/*/*[@datatype='string']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='case insensitive equals' or @operation='case insensitive not equal' or @operation='pattern match'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of string.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='version']|oval-def:states/*/*[@datatype='version']|oval-def:states/*/*/*[@datatype='version']">
                        <sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of version.</sch:assert>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@datatype='record']|oval-def:states/*/*[@datatype='record']|oval-def:states/*/*/*[@datatype='record']">
                        <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - The use of '<sch:value-of select="@operation"/>' for the operation attribute of the <sch:value-of select="name()"/> entity is not valid given a datatype of record.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_no_var_ref_with_records">
                    <sch:rule context="oval-def:objects/*/*[@datatype='record']|oval-def:states/*/*[@datatype='record']">
                        <sch:assert test="not(@var_ref)">
            <sch:value-of select="../@id"/> - The use of var_ref is prohibited when the datatype is 'record'.</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_definition_entity_type_check_rules">
                    <sch:rule context="oval-def:objects/*/*[not(@xsi:nil='true') and not(@var_ref) and @datatype='int']|oval-def:states/*/*[not(@xsi:nil='true') and not(@var_ref) and @datatype='int']">
                        <sch:assert test="(not(contains(.,'.'))) and (number(.) = floor(.))">
            <sch:value-of select="../@id"/> - The datatype for the <sch:value-of select="name()"/> entity is 'int' but the value is not an integer.</sch:assert>
						   <!--  Must test for decimal point because number(x.0) = floor(x.0) is true -->
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_entityobjectbaserules">
                    <sch:rule context="oval-def:objects/*/*[@var_ref]|oval-def:objects/*/*/*[@var_ref]">
                        <sch:report test="not(@var_check)">
            <sch:value-of select="../@id"/> - a var_ref has been supplied for the <sch:value-of select="name()"/> entity so a var_check should also be provided</sch:report>
                    </sch:rule>
                    <sch:rule context="oval-def:objects/*/*[@var_check]|oval-def:objects/*/*/*[@var_check]">
                            <sch:assert test="@var_ref">
            <sch:value-of select="../@id"/> - a var_check has been supplied for the <sch:value-of select="name()"/> entity so a var_ref should also be provided</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_entitystatebaserules">
                    <sch:rule context="oval-def:states/*/*[@var_ref]|oval-def:states/*/*/*[@var_ref]">
                        <sch:report test="not(@var_check)">
            <sch:value-of select="../@id"/> - a var_ref has been supplied for the <sch:value-of select="name()"/> entity so a var_check should also be provided</sch:report>
                    </sch:rule>
                    <sch:rule context="oval-def:states/*/*[@var_check]|oval-def:states/*/*/*[@var_check]">
                        <sch:assert test="@var_ref">
            <sch:value-of select="../@id"/> - a var_check has been supplied for the <sch:value-of select="name()"/> entity so a var_ref should also be provided</sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-def_state_record_fields">
                    <sch:rule context="oval-def:states/*/*/*">
                        <sch:assert test="not(@datatype='record')">
                            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> field of an <sch:value-of select="name(../..)"/> should not be 'record'.
                        </sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-sc_entity_rules">
                    <sch:rule context="oval-sc:system_data/*/*|oval-sc:system_data/*/*/*">
                        <sch:assert test="not(@status) or @status='exists' or .=''">item <sch:value-of select="../@id"/> - a value for the <sch:value-of select="name()"/> entity should only be supplied if the status attribute is 'exists'</sch:assert>
                        <sch:assert test="not(@mask) or @mask='false' or .=''">item <sch:value-of select="../@id"/> - a value for the <sch:value-of select="name()"/> entity should only be supplied if the mask attribute is 'false'</sch:assert>
                        <!--<sch:assert test="if (@datatype='binary') then (matches(., '^[0-9a-fA-F]*$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of binary.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='boolean') then (matches(., '^true$|^false$|^1$|^0$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of boolean.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='evr_string') then (matches(., '^[^:\-]*:[^:\-]*-[^:\-]*$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of evr_string.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='float') then (matches(., '^[+\-]?[0-9]+([\.][0-9]+)?([eE][+\-]?[0-9]+)?$|^NaN$|^INF$|^\-INF$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of float.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='int') then (matches(., '^[+\-]?[0-9]+$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of int.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-sc:system_data/*/*[not(@xsi:nil='true') and @datatype='int']|oval-sc:system_data/*/*/*[not(@xsi:nil='true') and @datatype='int']">
                        <sch:assert test="(not(contains(.,'.'))) and (number(.) = floor(.))">
            <sch:value-of select="../@id"/> - The datatype for the <sch:value-of select="name()"/> entity is 'int' but the value is not an integer.</sch:assert>
                        <!--  Must test for decimal point because number(x.0) = floor(x.0) is true -->                        
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-sc_item_record_fields">
                    <sch:rule context="oval-sc:system_data/*/*/*">
                            <sch:assert test="not(@datatype='record')">
                                <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> field of an <sch:value-of select="name(../..)"/> should not be 'record'
                            </sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="ind-def_famtst">
                              <sch:rule context="ind-def:family_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:family_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a family_test must reference a family_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:family_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:family_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a family_test must reference a family_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_famstefamily">
                                                            <sch:rule context="ind-def:family_state/ind-def:family">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the family entity of a family_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_hashtst">
                              <sch:rule context="ind-def:filehash_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:filehash_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a filehash_test must reference a filesha1_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:filehash_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:filehash_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a filehash_test must reference a filesha1_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_hashobjfilepath">
                                                                                    <sch:rule context="ind-def:filehash_object/ind-def:filepath">
                                                                                          <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a filehash_object should be 'string'</sch:assert>
                                                                                          <sch:assert test="not(preceding-sibling::ind-def:behaviors[@max_depth or @recurse_direction])">
            <sch:value-of select="../@id"/> - the max_depth and recurse_direction behaviors are not allowed with a filepath entity</sch:assert>
                                                                                    </sch:rule>
                                                                              </sch:pattern>
   <sch:pattern id="ind-def_hashobjpath">
                                                                                  <sch:rule context="ind-def:filehash_object/ind-def:path">
                                                                                        <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a filehash_object should be 'string'</sch:assert>
                                                                                  </sch:rule>
                                                                            </sch:pattern>
   <sch:pattern id="ind-def_hashobjfilename">
                                                                                  <sch:rule context="ind-def:filehash_object/ind-def:filename">
                                                                                        <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a filehash_object should be 'string'</sch:assert>
                                                                                  </sch:rule>
                                                                            </sch:pattern>
   <sch:pattern id="ind-def_hashstefilepath">
                                                            <sch:rule context="ind-def:filehash_state/ind-def:filepath">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a filehash_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_hashstepath">
                                                            <sch:rule context="ind-def:filehash_state/ind-def:path">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a filehash_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_hashstefilename">
                                                            <sch:rule context="ind-def:filehash_state/ind-def:filename">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a filehash_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_hashstemd5">
                                                            <sch:rule context="ind-def:filehash_state/ind-def:md5">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the md5 entity of a filehash_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_hashstesha1">
                                                            <sch:rule context="ind-def:filehash_state/ind-def:sha1">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the sha1 entity of a filehash_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_envtst">
                              <sch:rule context="ind-def:environmentvariable_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:environmentvariable_object/@id">
            <sch:value-of select="../@id"/> - the object child element of an environmentvariable_test must reference a environmentvariable_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:environmentvariable_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:environmentvariable_state/@id">
            <sch:value-of select="../@id"/> - the state child element of an environmentvariable_test must reference a environmentvariable_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_envobjname">
                                                                        <sch:rule context="ind-def:environmentvariable_object/ind-def:name">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the name entity of an environmentvariable_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_envstename">
                                                            <sch:rule context="ind-def:environmentvariable_state/ind-def:name">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the name entity of an environmentvariable_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_envstevalue">
                                                            <sch:rule context="ind-def:environmentvariable_state/ind-def:value">
                                                                  <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap_test_dep">
                              <sch:rule context="ind-def:ldap_test">
                                    <sch:report test="true()">DEPRECATED TEST: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_ldaptst">
                              <sch:rule context="ind-def:ldap_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:ldap_object/@id">
            <sch:value-of select="../@id"/> - the object child element of an ldap_test must reference an ldap_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:ldap_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:ldap_state/@id">
            <sch:value-of select="../@id"/> - the state child element of an ldap_test must reference an ldap_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_ldap_object_dep">
                              <sch:rule context="ind-def:ldap_object">
                                    <sch:report test="true()">DEPRECATED OBJECT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_ldapobjsuffix">
                                                                        <sch:rule context="ind-def:ldap_object/ind-def:suffix">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the suffix entity of an ldap_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_ldapobjrelative_dn">
                                                                        <sch:rule context="ind-def:ldap_object/ind-def:relative_dn">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an ldap_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_ldapobjattribute">
                                                                        <sch:rule context="ind-def:ldap_object/ind-def:attribute">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an ldap_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_ldap_state_dep">
                              <sch:rule context="ind-def:ldap_state">
                                    <sch:report test="true()">DEPRECATED STATE: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_ldapstesuffix">
                                                            <sch:rule context="ind-def:ldap_state/ind-def:suffix">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the suffix entity of an ldap_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldapsterelative_dn">
                                                            <sch:rule context="ind-def:ldap_state/ind-def:relative_dn">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an ldap_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldapsteattribute">
                                                            <sch:rule context="ind-def:ldap_state/ind-def:attribute">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an ldap_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldapsteobject_class">
                                                            <sch:rule context="ind-def:ldap_state/ind-def:object_class">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the object_class entity of an ldap_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldapsteldaptype">
                                                            <sch:rule context="ind-def:ldap_state/ind-def:ldaptype">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the ldaptype entity of an ldap_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldapsteldapvalue">
                                                            <sch:rule context="ind-def:ldap_state/ind-def:value">
                                                                  <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap57_test">
                              <sch:rule context="ind-def:ldap57_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:ldap57_object/@id">
            <sch:value-of select="../@id"/> - the object child element of an ldap57_test must reference an ldap57_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:ldap57_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:ldap57_state/@id">
            <sch:value-of select="../@id"/> - the state child element of an ldap57_test must reference an ldap57_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_ldap57_object_suffix">
                                                                        <sch:rule context="ind-def:ldap57_object/ind-def:suffix">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the suffix entity of an ldap57_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_ldap57_object_relative_dn">
                                                                        <sch:rule context="ind-def:ldap57_object/ind-def:relative_dn">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an ldap57_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_ldap57_object_attribute">
                                                                        <sch:rule context="ind-def:ldap57_object/ind-def:attribute">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an ldap57_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_ldap57_state_suffix">
                                                            <sch:rule context="ind-def:ldap57_state/ind-def:suffix">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the suffix entity of an ldap57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap57_state_relative_dn">
                                                            <sch:rule context="ind-def:ldap57_state/ind-def:relative_dn">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an ldap57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap57_state_attribute">
                                                            <sch:rule context="ind-def:ldap57_state/ind-def:attribute">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an ldap57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap57_state_object_class">
                                                            <sch:rule context="ind-def:ldap57_state/ind-def:object_class">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the object_class entity of an ldap57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap57_state_ldaptype">
                                                            <sch:rule context="ind-def:ldap57_state/ind-def:ldaptype">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the ldaptype entity of an ldap57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldap57_state_value">
                                                            <sch:rule context="ind-def:ldap57_state/ind-def:value">
                                                                  <sch:assert test="@datatype='record'">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sql_test_dep">
                              <sch:rule context="ind-def:sql_test">
                                    <sch:report test="true()">DEPRECATED TEST: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_sqltst">
                              <sch:rule context="ind-def:sql_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:sql_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a sql_test must reference a sql_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:sql_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:sql_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a sql_test must reference a sql_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_sql_object_dep">
                              <sch:rule context="ind-def:sql_object">
                                    <sch:report test="true()">DEPRECATED OBJECT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_sqlobjdengine">
                                                                        <sch:rule context="ind-def:sql_object/ind-def:engine">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the engine entity of an sql_object should be 'string'</sch:assert>
                                                                            <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the engine entity of an sql_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sqlobjversion">
                                                                        <sch:rule context="ind-def:sql_object/ind-def:version">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the version entity of an sql_object should be 'string'</sch:assert>
                                                                            <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the version entity of an sql_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sqlobjconnection_string">
                                                                        <sch:rule context="ind-def:sql_object/ind-def:connection_string">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the connection_string entity of an sql_object should be 'string'</sch:assert>
                                                                            <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the connection_string entity of an sql_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sqlobjsql">
                                                                        <sch:rule context="ind-def:sql_object/ind-def:sql">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the sql entity of a sql_object should be 'string'</sch:assert>
                                                                            <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the sql entity of an sql_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sql_state_dep">
                              <sch:rule context="ind-def:sql_state">
                                    <sch:report test="true()">DEPRECATED STATE: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_sqlsteengine">
                                                            <sch:rule context="ind-def:sql_state/ind-def:engine">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the engine entity of an sql_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sqlsteversion">
                                                            <sch:rule context="ind-def:sql_state/ind-def:version">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the version entity of an sql_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sqlsteconnection_string">
                                                            <sch:rule context="ind-def:sql_state/ind-def:connection_string">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the connection_string entity of an sql_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sqlstesql">
                                                            <sch:rule context="ind-def:sql_state/ind-def:sql">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the sql entity of a sql_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sqlsteresult">
                                                            <sch:rule context="ind-def:sql_state/ind-def:result">
                                                                  <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sql57_test">
                              <sch:rule context="ind-def:sql57_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:sql57_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a sql57_test must reference a sql57_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:sql57_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:sql57_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a sql57_test must reference a sql57_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_sql57_object_dengine">
                                                                        <sch:rule context="ind-def:sql57_object/ind-def:engine">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the engine entity of an sql57_object should be 'string'</sch:assert>
                                                                              <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the engine entity of an sql57_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sql57_object_version">
                                                                        <sch:rule context="ind-def:sql57_object/ind-def:version">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the version entity of an sql57_object should be 'string'</sch:assert>
                                                                              <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the version entity of an sql57_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sql57_object_connection_string">
                                                                        <sch:rule context="ind-def:sql57_object/ind-def:connection_string">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the connection_string entity of an sql57_object should be 'string'</sch:assert>
                                                                              <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the connection_string entity of an sql57_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sql57_object_sql">
                                                                        <sch:rule context="ind-def:sql57_object/ind-def:sql">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the sql entity of a sql57_object should be 'string'</sch:assert>
                                                                              <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the sql entity of an sql57_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_sql57_state_engine">
                                                            <sch:rule context="ind-def:sql57_state/ind-def:engine">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the engine entity of an sql57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sql57_state_version">
                                                            <sch:rule context="ind-def:sql57_state/ind-def:version">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the version entity of an sql57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sql57_state_connection_string">
                                                            <sch:rule context="ind-def:sql57_state/ind-def:connection_string">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the connection_string entity of an sql57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sql57_state_sql">
                                                            <sch:rule context="ind-def:sql57_state/ind-def:sql">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the sql entity of a sql57_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_sql57_state_result">
                                                            <sch:rule context="ind-def:sql57_state/ind-def:result">
                                                                  <sch:assert test="@datatype='record'">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54tst">
                              <sch:rule context="ind-def:textfilecontent54_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a textfilecontent54_test must reference a textfilecontent54_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:textfilecontent54_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a textfilecontent54_test must reference a textfilecontent54_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_txt54objfilepath">
                                                                                    <sch:rule context="ind-def:textfilecontent54_object/ind-def:filepath">
                                                                                          <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a textfilecontent54_object should be 'string'</sch:assert>
                                                                                          <sch:assert test="not(preceding-sibling::ind-def:behaviors[@max_depth or @recurse_direction])">
            <sch:value-of select="../@id"/> - the max_depth and recurse_direction behaviors are not allowed with a filepath entity</sch:assert>
                                                                                    </sch:rule>
                                                                              </sch:pattern>
   <sch:pattern id="ind-def_txt54objpath">
                                                                                  <sch:rule context="ind-def:textfilecontent54_object/ind-def:path">
                                                                                        <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a textfilecontent54_object should be 'string'</sch:assert>
                                                                                  </sch:rule>
                                                                            </sch:pattern>
   <sch:pattern id="ind-def_txt54objfilename">
                                                                                  <sch:rule context="ind-def:textfilecontent54_object/ind-def:filename">
                                                                                        <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a textfilecontent54_object should be 'string'</sch:assert>
                                                                                  </sch:rule>
                                                                            </sch:pattern>
   <sch:pattern id="ind-def_txt54objpattern">
                                                                        <sch:rule context="ind-def:textfilecontent54_object/ind-def:pattern">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the pattern entity of a textfilecontent54_object should be 'string'</sch:assert>
                                                                              <sch:assert test="@operation='pattern match'">
            <sch:value-of select="../@id"/> - operation attribute for the pattern entity of a textfilecontent54_object should be 'pattern match'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_txt54objinstance">
                                                                        <sch:rule context="ind-def:textfilecontent54_object/ind-def:instance">
                                                                              <sch:assert test="@datatype='int'">
            <sch:value-of select="../@id"/> - datatype attribute for the instance entity of a textfilecontent54_object should be 'int'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_txt54stefilepath">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:filepath">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a textfilecontent54_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54stepath">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:path">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a textfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54stefilename">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:filename">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a textfilecontent54_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54stepattern">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:pattern">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the pattern entity of a textfilecontent54_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54steinstance">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:instance">
                                                                  <sch:assert test="@datatype='int'">
            <sch:value-of select="../@id"/> - datatype attribute for the instance entity of a textfilecontent54_state should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54stetext">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:text">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the text entity of a textfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txt54stesubexpression">
                                                            <sch:rule context="ind-def:textfilecontent54_state/ind-def:subexpression">
                                                                  <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txttst_dep">
                              <sch:rule context="ind-def:textfilecontent_test">
                                    <sch:report test="true()">
                                          DEPRECATED TEST: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
                                    </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_txttst">
                              <sch:rule context="ind-def:textfilecontent_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a textfilecontent_test must reference a textfilecontent_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:textfilecontent_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a textfilecontent_test must reference a textfilecontent_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_txtobj_dep">
                              <sch:rule context="ind-def:textfilecontent_object">
                                    <sch:report test="true()">
                                          DEPRECATED OBJECT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
                                    </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_txtobjpath">
                                                                        <sch:rule context="ind-def:textfilecontent_object/ind-def:path">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a textfilecontent_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_txtobjfilename">
                                                                        <sch:rule context="ind-def:textfilecontent_object/ind-def:filename">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a textfilecontent_object should be 'string'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_txtobjline">
                                                                        <sch:rule context="ind-def:textfilecontent_object/ind-def:line">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the line entity of a textfilecontent_object should be 'string'</sch:assert>
                                                                              <sch:assert test="@operation='pattern match'">
            <sch:value-of select="../@id"/> - operation attribute for the line entity of a textfilecontent_object should be 'pattern match'</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_txtste_dep">
                              <sch:rule context="ind-def:textfilecontent_state">
                                    <sch:report test="true()">
                                          DEPRECATED STATE: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
                                    </sch:report>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_txtstepath">
                                                            <sch:rule context="ind-def:textfilecontent_state/ind-def:path">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a textfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txtstefilename">
                                                            <sch:rule context="ind-def:textfilecontent_state/ind-def:filename">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a textfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txtsteline">
                                                            <sch:rule context="ind-def:textfilecontent_state/ind-def:line">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the line entity of a textfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_txtstesubexpression">
                                                            <sch:rule context="ind-def:textfilecontent_state/ind-def:subexpression">
                                                                  <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_vattst">
                              <sch:rule context="ind-def:variable_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:variable_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a variable_test must reference a variable_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:variable_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:variable_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a variable_test must reference a variable_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_varobjvar_ref">
                                                                        <sch:rule context="ind-def:variable_object/ind-def:var_ref">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the var_ref entity of a variable_object should be 'string'</sch:assert>
                                                                              <sch:assert test="not(@var_ref)">
            <sch:value-of select="../@id"/> - var_ref attribute for the var_ref entity of a variable_object is prohibited.</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_varstevar_ref">
                                                            <sch:rule context="ind-def:variable_state/ind-def:var_ref">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the var_ref entity of a variable_state should be 'string'</sch:assert>
                                                                  <sch:assert test="not(@var_ref)">
            <sch:value-of select="../@id"/> - var_ref attribute for the var_ref entity of a variable_state is prohibited.</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_xmltst">
                              <sch:rule context="ind-def:xmlfilecontent_test/ind-def:object">
                                    <sch:assert test="@object_ref=ancestor::oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object/@id">
            <sch:value-of select="../@id"/> - the object child element of a xmlfilecontent_test must reference a xmlfilecontent_object</sch:assert>
                              </sch:rule>
                              <sch:rule context="ind-def:xmlfilecontent_test/ind-def:state">
                                    <sch:assert test="@state_ref=ancestor::oval-def:oval_definitions/oval-def:states/ind-def:xmlfilecontent_state/@id">
            <sch:value-of select="../@id"/> - the state child element of a xmlfilecontent_test must reference a xmlfilecontent_state</sch:assert>
                              </sch:rule>
                        </sch:pattern>
   <sch:pattern id="ind-def_xmlobjfilepath">
                                                                                    <sch:rule context="ind-def:xmlfilecontent_object/ind-def:filepath">
                                                                                          <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a xmlfilecontent_object should be 'string'</sch:assert>
                                                                                          <sch:assert test="not(preceding-sibling::ind-def:behaviors[@max_depth or @recurse_direction])">
            <sch:value-of select="../@id"/> - the max_depth and recurse_direction behaviors are not allowed with a filepath entity</sch:assert>
                                                                                    </sch:rule>
                                                                              </sch:pattern>
   <sch:pattern id="ind-def_xmlobjpath">
                                                                                  <sch:rule context="ind-def:xmlfilecontent_object/ind-def:path">
                                                                                        <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a xmlfilecontent_object should be 'string'</sch:assert>
                                                                                  </sch:rule>
                                                                            </sch:pattern>
   <sch:pattern id="ind-def_xmlobjfilename">
                                                                                  <sch:rule context="ind-def:xmlfilecontent_object/ind-def:filename">
                                                                                        <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a xmlfilecontent_object should be 'string'</sch:assert>
                                                                                  </sch:rule>
                                                                            </sch:pattern>
   <sch:pattern id="ind-def_xmlobjxpath">
                                                                        <sch:rule context="ind-def:xmlfilecontent_object/ind-def:xpath">
                                                                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the xpath entity of a xmlfilecontent_object should be 'string'</sch:assert>
                                                                            <sch:assert test="not(@operation) or @operation='equals'">
            <sch:value-of select="../@id"/> - operation attribute for the xpath entity of a xmlfilecontent_object should be 'equals', note that this overrules the general operation attribute validation (i.e. follow this one)</sch:assert>
                                                                        </sch:rule>
                                                                  </sch:pattern>
   <sch:pattern id="ind-def_xmlfilestefilepath">
                                                            <sch:rule context="ind-def:xmlfilecontent_state/ind-def:filepath">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a xmlfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_xmlstepath">
                                                            <sch:rule context="ind-def:xmlfilecontent_state/ind-def:path">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the path entity of a xmlfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_xmlstefilename">
                                                            <sch:rule context="ind-def:xmlfilecontent_state/ind-def:filename">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a xmlfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_xmlstexpath">
                                                            <sch:rule context="ind-def:xmlfilecontent_state/ind-def:xpath">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the xpath entity of a xmlfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_xmlstevalue_of">
                                                            <sch:rule context="ind-def:xmlfilecontent_state/ind-def:value_of">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the value_of entity of a xmlfilecontent_state should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="ind-def_ldaptype_timestamp_value_dep">
                                                <sch:rule context="oval-def:oval_definitions/oval-def:states/ind-def:ldap_state/ind-def:ldaptype|oval-def:oval_definitions/oval-def:states/ind-def:ldap57_state/ind-def:ldaptype">
                                                      <sch:report test=".='LDAPTYPE_TIMESTAMP'">
                                                            DEPRECATED ELEMENT VALUE IN: ldap_state ELEMENT VALUE: <sch:value-of select="."/> 
                                                      </sch:report>
                                                </sch:rule>
                                          </sch:pattern>
   <sch:pattern id="ind-def_ldaptype_email_value_dep">
                                                <sch:rule context="oval-def:oval_definitions/oval-def:states/ind-def:ldap_state/ind-def:ldaptype|oval-def:oval_definitions/oval-def:states/ind-def:ldap57_state/ind-def:ldaptype">
                                                      <sch:report test=".='LDAPTYPE_EMAIL'">
                                                            DEPRECATED ELEMENT VALUE IN: ldap_state ELEMENT VALUE: <sch:value-of select="."/> 
                                                      </sch:report>
                                                </sch:rule>
                                          </sch:pattern>
   <sch:diagnostics/>
</sch:schema>