<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsd="http://www.w3.org/2001/XMLSchema" queryBinding="xslt2">
      <sch:title>schematron validation for an OVAL Results file</sch:title>
      <sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>
      <sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5"/>
      <sch:ns prefix="oval-res" uri="http://oval.mitre.org/XMLSchema/oval-results-5"/>
      <sch:ns prefix="oval-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5"/>
      <sch:ns prefix="oval-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"/>
      <sch:pattern id="system">
            <sch:rule context="oval-res:system[oval-res:tests]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">the tests element should not be included unless full results are to be provided (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:system[not(oval-res:tests)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">the tests element should be included when full results are specified (see directives)</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="directives">
            <sch:rule context="oval-res:definition[@result='true' and oval-res:criteria]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='true' and not(oval-res:criteria)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should not be included (see directives) xx</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='false' and oval-res:criteria]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should contain THIN content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='false' and not(oval-res:criteria)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of FALSE should contain FULL content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='unknown' and oval-res:criteria]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should contain THIN content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='unknown' and not(oval-res:criteria)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of UNKNOWN should contain FULL content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='error' and oval-res:criteria]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should contain THIN content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='error' and not(oval-res:criteria)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of ERROR should contain FULL content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='not evaluated' and oval-res:criteria]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should contain THIN content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='not evaluated' and not(oval-res:criteria)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should contain FULL content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='not applicable' and oval-res:criteria]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should contain THIN content (see directives)</sch:assert>
            </sch:rule>
            <sch:rule context="oval-res:definition[@result='not applicable' and not(oval-res:criteria)]">
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
                  <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">
                        <sch:value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should contain FULL content (see directives)</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="testids">
            <sch:rule context="oval-res:test">
                  <sch:assert test="@test_id = ../../oval-res:definitions//oval-res:criterion/@test_ref">
                        <sch:value-of select="@test_id"/> - the specific test is not used in any definition's criteria</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="empty_def_doc">
            <sch:rule context="oval-def:oval_definitions">
                  <sch:assert test="oval-def:definitions or oval-def:tests or oval-def:objects or oval-def:states or oval-def:variables">A valid OVAL Definition document must contain at least one definitions, tests, objects, states, or variables element. The optional definitions, tests, objects, states, and variables sections define the specific characteristics that should be evaluated on a system to determine the truth values of the OVAL Definition Document. To be valid though, at least one definitions, tests, objects, states, or variables element must be present.</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="required_criteria">
            <sch:rule context="/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[@deprecated='false' or not(@deprecated)]">
                  <sch:assert test="oval-def:criteria">A valid OVAL Definition document must contain a criteria unless the definition is a deprecated definition.</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="test_type">
            <sch:rule context="/oval-def:oval_definitions/oval-def:tests/*[@check_existence='none_exist']">
                  <sch:assert test="not(*[name()='state'])">
                        <sch:value-of select="@id"/> - No state should be referenced when check_existence has a value of 'none_exist'.</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="setobjref">
            <sch:rule context="/oval-def:oval_definitions/oval-def:objects/*/oval-def:set/oval-def:object_reference">
                  <sch:assert test="name(./../..) = name(/oval-def:oval_definitions/oval-def:objects/*[@id=current()])">
                        <sch:value-of select="../../@id"/> - Each object referenced by the set must be of the same type as parent object</sch:assert>
            </sch:rule>
            <sch:rule context="/oval-def:oval_definitions/oval-def:objects/*/oval-def:set/oval-def:set/oval-def:object_reference">
                  <sch:assert test="name(./../../..) = name(/oval-def:oval_definitions/oval-def:objects/*[@id=current()])">
                        <sch:value-of select="../../../@id"/> - Each object referenced by the set must be of the same type as parent object</sch:assert>
            </sch:rule>
            <sch:rule context="/oval-def:oval_definitions/oval-def:objects/*/oval-def:set/oval-def:set/oval-def:set/oval-def:object_reference">
                  <sch:assert test="name(./../../../..) = name(/oval-def:oval_definitions/oval-def:objects/*[@id=current()])">
                        <sch:value-of select="../../../../@id"/> - Each object referenced by the set must be of the same type as parent object</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="value">
            <sch:rule context="oval-def:constant_variable/oval-def:value">
                  <sch:assert test=".!=''">The value element of the constant_variable <sch:value-of select="../../@id"/> can not be empty.</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="literal_component">
            <sch:rule context="oval-def:literal_component">
                  <sch:assert test=".!=''">The literal_component of variable <sch:value-of select="../../@id"/> can not be empty.</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="item_field">
            <sch:rule context="oval-def:object_component">
                  <sch:assert test="@item_field!=''">The item_field attribute of an object_component of variable <sch:value-of select="../../@id"/> can not be empty.</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="entityrules">
            <sch:rule context="oval-def:objects/*/*|oval-def:states/*/*">
                  <sch:let name="var_ref" value="@var_ref"/>
                  <sch:assert test="((not(@datatype) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='case insensitive equals' or @operation='case insensitive not equal' or @operation='pattern match')) or (@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='boolean' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='evr_string' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal')) or (@datatype='fileset_revision' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal')) or (@datatype='ios_version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='string' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal')))">
                        <sch:value-of select="../@id"/> - the supplied operation attribute for the <sch:value-of select="name()"/> entity is not valid given a datatype of '<sch:value-of select="@datatype"/>'</sch:assert>
                  <sch:assert test="not(@var_ref) or .=''">
                        <sch:value-of select="../@id"/> - a var-ref has been supplied for the <sch:value-of select="name()"/> entity so no value should be provided</sch:assert>
                  <sch:assert test="if (@var_ref) then (if (@datatype) then (@datatype=/oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype) else ('string' = /oval-def:oval_definitions/oval-def:variables/*[@id=$var_ref]/@datatype)) else (1=1)">
                        <sch:value-of select="$var_ref"/> - inconsistent datatype between the variable and an associated var_ref</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:pattern id="entitystatus">
            <sch:rule context="oval-sc:system_data/*/*">
                  <sch:assert test="not(@status) or @status='exists' or .=''">item <sch:value-of select="../@id"/> - a value for the <sch:value-of select="name()"/> entity should only be supplied if the status attribute is 'exists'</sch:assert>
                  <sch:assert test="not(@mask) or @mask='false' or .=''">item <sch:value-of select="../@id"/> - a value for the <sch:value-of select="name()"/> entity should only be supplied if the mask attribute is 'false'</sch:assert>
            </sch:rule>
      </sch:pattern>
      <sch:diagnostics/>
</sch:schema>
