<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
    <sch:title>schematron validation for an OVAL System Characteristics file</sch:title>
    <sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>
    <sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5"/>
    <sch:ns prefix="oval-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"/>
    <sch:ns prefix="ind-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"/>
    <sch:ns prefix="apache-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#apache"/>
    <sch:ns prefix="hpux-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#hpux"/>
    <sch:ns prefix="ios-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#ios"/>
    <sch:ns prefix="linux-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"/>
    <sch:ns prefix="macos-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#macos"/>
    <sch:ns prefix="sol-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#solaris"/>
    <sch:ns prefix="unix-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"/>
    <sch:ns prefix="win-sc" uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"/>
    <sch:pattern id="entitystatus">
        <sch:rule context="oval-sc:system_data/*/*">
            <sch:assert test="not(@status) or @status='exists' or .=''">item <value-of select="../@id"/> - a value for the <value-of select="name()"/> entity should only be supplied if the status attribute is 'exists'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="famitemfamily">
        <sch:rule context="ind-sc:family_item/ind-sc:family">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the family entity of a family_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="md5itempath">
        <sch:rule context="ind-sc:filemd5_item/ind-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a filemd5_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="md5itemfilename">
        <sch:rule context="ind-sc:filemd5_item/ind-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a filemd5_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="md5itemmd5">
        <sch:rule context="ind-sc:filemd5_item/ind-sc:md5">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the md5 entity of a filemd5_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="envitemname">
        <sch:rule context="ind-sc:environmentvariable_item/ind-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of an environmentvariable_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="txtitempath">
        <sch:rule context="ind-sc:textfilecontent_item/ind-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a textfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="txtitemfilename">
        <sch:rule context="ind-sc:textfilecontent_item/ind-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a textfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="txtitemline">
        <sch:rule context="ind-sc:textfilecontent_item/ind-sc:line">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the line entity of a textfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="txtitemsubexpression">
        <sch:rule context="ind-sc:textfilecontent_item/ind-sc:subexpression">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the subexpression entity of a textfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="varitemvar_ref">
        <sch:rule context="ind-sc:variable_item/ind-sc:var_ref">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the var_ref entity of a variable_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xmlitempath">
        <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a xmlfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xmlitemfilename">
        <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a xmlfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xmlitemxpath">
        <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:xpath">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the xpath entity of a xmlfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xmlitemvalue_of">
        <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:value_of">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the value_of entity of a xmlfilecontent_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="httpditempath">
        <sch:rule context="apache-sc:httpd_item/apache-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a httpd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="httpditembinaryname">
        <sch:rule context="apache-sc:httpd_item/apache-sc:binary_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the binary_name entity of a httpd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="httpditemversion">
        <sch:rule context="apache-sc:httpd_item/apache-sc:version">
            <sch:assert test="@datatype='version'">item <value-of select="../@id"/> - datatype attribute for the version entity of a httpd_item should be 'version'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="apacheveritemversion">
        <sch:rule context="apache-sc:version_item/apache-sc:version">
            <sch:assert test="not(@datatype) or @datatype='version'">item <value-of select="../@id"/> - datatype attribute for the version entity of a version_item should be 'version'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="gcitemparameter_name">
        <sch:rule context="hpux-sc:getconf_item/hpux-sc:parameter_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the parameter_name entity of a getconf_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="gcitempathname">
        <sch:rule context="hpux-sc:getconf_item/hpux-sc:pathname">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pathname entity of a getconf_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="gcitemoutput">
        <sch:rule context="hpux-sc:getconf_item/hpux-sc:output">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the output entity of a getconf_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="patchitemarea_patched">
        <sch:rule context="hpux-sc:patch_item/hpux-sc:area_patched">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the area_patched entity of a patch_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="patchitempatch_number">
        <sch:rule context="hpux-sc:patch_item/hpux-sc:patch_number">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the patch_number entity of a patch_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="swlistitemswlist">
        <sch:rule context="hpux-sc:swlist_item/hpux-sc:swlist">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the swlist entity of a swlist_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="swlistitembundle">
        <sch:rule context="hpux-sc:swlist_item/hpux-sc:bundle">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the bundle entity of a swlist_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="swlistitemfileset">
        <sch:rule context="hpux-sc:swlist_item/hpux-sc:fileset">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the fileset entity of a swlist_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="swlistitemversion">
        <sch:rule context="hpux-sc:swlist_item/hpux-sc:version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the version entity of a swlist_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="swlistitemtitle">
        <sch:rule context="hpux-sc:swlist_item/hpux-sc:title">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the title entity of a swlist_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="swlistitemvendor">
        <sch:rule context="hpux-sc:swlist_item/hpux-sc:vendor">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the vendor entity of a swlist_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemtrustitem">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:trustitem">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustitem entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemuid">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:uid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the uid entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempassword">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:password">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the password entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemaccount_owner">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:account_owner">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the account_owner entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemboot_auth">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:boot_auth">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the boot_auth entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemaudit_id">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:audit_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the audit_id entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemaudit_flag">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:audit_flag">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the audit_flag entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_change_min">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_change_min">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_change_min entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_max_size">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_max_size">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_max_size entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_expiration">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_expiration">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_expiration entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_life">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_life">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_life entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_change_s">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_change_s">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_change_s entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_change_u">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_change_u">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_change_u entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemacct_expire">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:acct_expire">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the acct_expire entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemmax_llogin">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:max_llogin">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the max_llogin entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemexp_warning">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:exp_warning">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the exp_warning entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemusr_chg_pw">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:usr_chg_pw">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the usr_chg_pw entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemgen_pw">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:gen_pw">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the gen_pw entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_restrict">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_restrict">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_restrict entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_null">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_null">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_null entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_gen_char">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_gen_char">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_gen_char entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_gen_let">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:swlistpw_gen_let">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_gen_let entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemlogin_time">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:login_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_time entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitempw_changer">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_changer">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pw_changer entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemlogin_time_s">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:login_time_s">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_time_s entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemlogin_time_u">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:login_time_u">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_time_u entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemlogin_tty_s">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:login_tty_s">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_tty_s entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemlogin_tty_u">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:login_tty_u">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_tty_u entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemnum_u_logins">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:num_u_logins">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the num_u_logins entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemmax_u_logins">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:max_u_logins">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the max_u_logins entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="trustitemlock_flag">
        <sch:rule context="hpux-sc:trusted_item/hpux-sc:lock_flag">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the lock_flag entity of a trusted_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="globalitemglobal_command">
        <sch:rule context="ios-sc:global_item/ios-sc:global_command">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the global_command entity of a global_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemname">
        <sch:rule context="ios-sc:interface_item/ios-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a global_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemip_directed_broadcast_command">
        <sch:rule context="ios-sc:interface_item/ios-sc:ip_directed_broadcast_command">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the ip_directed_broadcast_command entity of a global_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemno_ip_directed_broadcast_command">
        <sch:rule context="ios-sc:interface_item/ios-sc:no_ip_directed_broadcast_command">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the no_ip_directed_broadcast_command entity of a global_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemproxy_arp_command">
        <sch:rule context="ios-sc:interface_item/ios-sc:proxy_arp_command">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the proxy_arp_command entity of a global_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemshutdown_command">
        <sch:rule context="ios-sc:interface_item/ios-sc:shutdown_command">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the shutdown_command entity of a global_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="lineitemshow_subcommand">
        <sch:rule context="ios-sc:line_item/ios-sc:show_subcommand">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the show_subcommand entity of a line_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="lineitemconfig_line">
        <sch:rule context="ios-sc:line_item/ios-sc:config_line">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the config_line entity of a line_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="snmpitemaccess_list">
        <sch:rule context="ios-sc:snmp_item/ios-sc:access_list">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the access_list entity of a snmp_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="snmpitemcommunity_name">
        <sch:rule context="ios-sc:snmp_item/ios-sc:community_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the community_name entity of a snmp_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="tclshitemavailable">
        <sch:rule context="ios-sc:tclsh_item/ios-sc:available">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the available entity of a tclsh_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="versionitemcommunity_name">
        <sch:rule context="ios-sc:version_item/ios-sc:community_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the community_name entity of a version_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="versionitemcommunity_name">
        <sch:rule context="ios-sc:version_item/ios-sc:community_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the community_name entity of a version_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="versionitemcommunity_name">
        <sch:rule context="ios-sc:version_item/ios-sc:community_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the community_name entity of a version_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="versionitemcommunity_name">
        <sch:rule context="ios-sc:version_item/ios-sc:community_name">
            <sch:assert test="not(@datatype) or @datatype='ios_version'">item <value-of select="../@id"/> - datatype attribute for the community_name entity of a version_item should be 'ios_version'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="dpkgitemname">
        <sch:rule context="linux-sc:dpkginfo_item/linux-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a dpkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="dpkgitemarch">
        <sch:rule context="linux-sc:dpkginfo_item/linux-sc:arch">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the arch entity of a dpkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="dpkgitemepoch">
        <sch:rule context="linux-sc:dpkginfo_item/linux-sc:epoch">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the epoch entity of a dpkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="dpkgitemrelease">
        <sch:rule context="linux-sc:dpkginfo_item/linux-sc:release">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the release entity of a dpkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="dpkgitemversion">
        <sch:rule context="linux-sc:dpkginfo_item/linux-sc:version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the version entity of a dpkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="dpkgitemevr">
        <sch:rule context="linux-sc:dpkginfo_item/linux-sc:evr">
            <sch:assert test="not(@datatype) or @datatype='evr_string'">item <value-of select="../@id"/> - datatype attribute for the evr entity of a dpkginfo_item should be 'evr_string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemprotocol">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:protocol">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the protocol entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemlocal_address">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:local_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemlocal_port">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:local_port">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemlocal_full_address">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:local_full_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemprogram_name">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:program_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the program_name entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemforeign_address">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:foreign_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the foreign_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemforeign_port">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:foreign_port">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the foreign_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemforeign_full_address">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:foreign_full_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the foreign_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitempid">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:pid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the pid entity of an inetlisteningserver_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemuser_id">
        <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:user_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user_id entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemname">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a rpminfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemarch">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:arch">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the arch entity of a rpminfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemepoch">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:epoch">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the epoch entity of a rpminfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemrelease">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:release">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the release entity of a rpminfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemversion">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the version entity of a rpminfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemevr">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:evr">
            <sch:assert test="not(@datatype) or @datatype='evr_string'">item <value-of select="../@id"/> - datatype attribute for the evr entity of a rpminfo_item should be 'evr_string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rpmitemsignature_keyid">
        <sch:rule context="linux-sc:rpminfo_item/linux-sc:signature_keyid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the signature_keyid entity of a rpminfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="spkginfoitemname">
        <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a slackwarepkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="spkginfoitemversion">
        <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the version entity of a slackwarepkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="spkginfoitemarchitecture">
        <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:architecture">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the architecture entity of a slackwarepkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="spkginfoitemrevision">
        <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:revision">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the revision entity of a slackwarepkginfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitemusername">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:username">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the username entity of an accountinfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitempassword">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:password">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the password entity of an accountinfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitemuid">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:uid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the uid entity of an accountinfo_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitemgid">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:gid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the gid entity of an accountinfo_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitemrealname">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:realname">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the realname entity of an accountinfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitemhome_dir">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:home_dir">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the home_dir entity of an accountinfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="accountitemlogin_shell">
        <sch:rule context="macos-sc:accountinfo_item/macos-sc:login_shell">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_shell entity of an accountinfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemprogram_name">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:program_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the program_name entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemlocal_address">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:local_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemlocal_full_address">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:local_full_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemlocal_port">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:local_port">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemforeign_address">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:foreign_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the foreign_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemforeign_full_address">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:foreign_full_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the foreign_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemforeign_port">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:foreign_port">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the foreign_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitempid">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:pid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the pid entity of an inetlisteningserver_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemprotocol">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:protocol">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the protocol entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ilsitemuser_id">
        <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:user_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user_id entity of an inetlisteningserver_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="nvramitemnvram_var">
        <sch:rule context="macos-sc:nvram_item/macos-sc:nvram_var">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the nvram_var entity of a nvram_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="nvramitemnvram_value">
        <sch:rule context="macos-sc:nvram_item/macos-sc:nvram_value">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the nvram_value entity of a nvram_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemusername">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:username">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the username entity of a pwpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemuserpass">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:userpass">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the userpass entity of a pwpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemdirectory_node">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:directory_node">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the directory_node entity of a pwpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemmaxChars">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:maxChars">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the maxChars entity of a pwpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemmaxFailedLoginAttempts">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:maxFailedLoginAttempts">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the maxFailedLoginAttempts entity of a pwpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemminChars">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:minChars">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the minChars entity of a pwpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitempasswordCannotBeName">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:passwordCannotBeName">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the passwordCannotBeName entity of a pwpolicy_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemrequiresAlpha">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:requiresAlpha">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the requiresAlpha entity of a pwpolicy_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="pwpitemrequiresNumeric">
        <sch:rule context="macos-sc:pwpolicy_item/macos-sc:requiresNumeric">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the requiresNumeric entity of a pwpolicy_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="isaitembits">
        <sch:rule context="sol-sc:isainfo_item/sol-sc:bits">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the bits entity of an isainfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="isaitemkernel_isa">
        <sch:rule context="sol-sc:isainfo_item/sol-sc:kernel_isa">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the kernel_isa entity of an isainfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="isaitemapplication_isa">
        <sch:rule context="sol-sc:isainfo_item/sol-sc:application_isa">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the application_isa entity of an isainfo_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="packageitempkginst">
        <sch:rule context="sol-sc:package_item/sol-sc:pkginst">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the pkginst entity of a package_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="packageitemname">
        <sch:rule context="sol-sc:package_item/sol-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a package_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="packageitemcategory">
        <sch:rule context="sol-sc:package_item/sol-sc:category">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the category entity of a package_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="packageitemversion">
        <sch:rule context="sol-sc:package_item/sol-sc:version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the version entity of a package_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="packageitemvendor">
        <sch:rule context="sol-sc:package_item/sol-sc:vendor">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the vendor entity of a package_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="packageitemdescription">
        <sch:rule context="sol-sc:package_item/sol-sc:description">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the description entity of a package_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="patchitembase">
        <sch:rule context="sol-sc:patch_item/sol-sc:base">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the base entity of a patch_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="patchitemversion">
        <sch:rule context="sol-sc:patch_item/sol-sc:version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the version entity of a patch_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitempath">
        <sch:rule context="unix-sc:file_item/unix-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemfilename">
        <sch:rule context="unix-sc:file_item/unix-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemtype">
        <sch:rule context="unix-sc:file_item/unix-sc:type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the type entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemgroup_id">
        <sch:rule context="unix-sc:file_item/unix-sc:group_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the group_id entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemuser_id">
        <sch:rule context="unix-sc:file_item/unix-sc:user_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user_id entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitema_time">
        <sch:rule context="unix-sc:file_item/unix-sc:a_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the a_time entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemc_time">
        <sch:rule context="unix-sc:file_item/unix-sc:c_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the c_time entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemm_time">
        <sch:rule context="unix-sc:file_item/unix-sc:m_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the m_time entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemsize">
        <sch:rule context="unix-sc:file_item/unix-sc:size">
            <sch:assert test="@datatype='int'">item <value-of select="../@id"/> - datatype attribute for the size entity of a file_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemsuid">
        <sch:rule context="unix-sc:file_item/unix-sc:suid">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the suid entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemsgid">
        <sch:rule context="unix-sc:file_item/unix-sc:sgid">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sgid entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemsticky">
        <sch:rule context="unix-sc:file_item/unix-sc:sticky">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sticky entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemuread">
        <sch:rule context="unix-sc:file_item/unix-sc:uread">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the uread entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemuwrite">
        <sch:rule context="unix-sc:file_item/unix-sc:uwrite">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the uwrite entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemuexec">
        <sch:rule context="unix-sc:file_item/unix-sc:uexec">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the uexec entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemgread">
        <sch:rule context="unix-sc:file_item/unix-sc:gread">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the gread entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemgwrite">
        <sch:rule context="unix-sc:file_item/unix-sc:gwrite">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the gwrite entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemgexec">
        <sch:rule context="unix-sc:file_item/unix-sc:gexec">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the gexec entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemoread">
        <sch:rule context="unix-sc:file_item/unix-sc:oread">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the oread entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemowrite">
        <sch:rule context="unix-sc:file_item/unix-sc:owrite">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the owrite entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixfileitemoexec">
        <sch:rule context="unix-sc:file_item/unix-sc:oexec">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the oexec entity of a file_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemprotocol">
        <sch:rule context="unix-sc:inetd_item/unix-sc:protocol">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the protocol entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemservice_name">
        <sch:rule context="unix-sc:inetd_item/unix-sc:service_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the service_name entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemserver_program">
        <sch:rule context="unix-sc:inetd_item/unix-sc:server_program">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the server_program entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemserver_arguments">
        <sch:rule context="unix-sc:inetd_item/unix-sc:server_arguments">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the server_arguments entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemendpoint_type">
        <sch:rule context="unix-sc:inetd_item/unix-sc:endpoint_type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the endpoint_type entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemexec_as_user">
        <sch:rule context="unix-sc:inetd_item/unix-sc:exec_as_user">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the exec_as_user entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="inetditemwait_status">
        <sch:rule context="unix-sc:inetd_item/unix-sc:wait_status">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the wait_status entity of an inetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixinterfaceitemname">
        <sch:rule context="unix-sc:interface_item/unix-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixinterfaceitemhardware_addr">
        <sch:rule context="unix-sc:interface_item/unix-sc:hardware_addr">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the hardware_addr entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixinterfaceiteminet_addr">
        <sch:rule context="unix-sc:interface_item/unix-sc:inet_addr">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the inet_addr entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixinterfaceitembroadcast_addr">
        <sch:rule context="unix-sc:interface_item/unix-sc:broadcast_addr">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the broadcast_addr entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixinterfaceitemnetmask">
        <sch:rule context="unix-sc:interface_item/unix-sc:netmask">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the netmask entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixinterfaceitemflag">
        <sch:rule context="unix-sc:interface_item/unix-sc:flag">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the flag entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditemusername">
        <sch:rule context="unix-sc:password_item/unix-sc:username">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the username entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditempassword">
        <sch:rule context="unix-sc:password_item/unix-sc:password">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the password entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditemuser_id">
        <sch:rule context="unix-sc:password_item/unix-sc:user_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user_id entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditemgroup_id">
        <sch:rule context="unix-sc:password_item/unix-sc:group_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the group_id entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditemgcos">
        <sch:rule context="unix-sc:password_item/unix-sc:gcos">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the gcos entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditemhome_dir">
        <sch:rule context="unix-sc:password_item/unix-sc:home_dir">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the home_dir entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="passworditemlogin_shell">
        <sch:rule context="unix-sc:password_item/unix-sc:login_shell">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the login_shell entity of a password_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemcommand">
        <sch:rule context="unix-sc:process_item/unix-sc:command">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the command entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemexec_time">
        <sch:rule context="unix-sc:process_item/unix-sc:exec_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the exec_time entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitempid">
        <sch:rule context="unix-sc:process_item/unix-sc:pid">
            <sch:assert test="@datatype='int'">item <value-of select="../@id"/> - datatype attribute for the pid entity of a process_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemppid">
        <sch:rule context="unix-sc:process_item/unix-sc:ppid">
            <sch:assert test="@datatype='int'">item <value-of select="../@id"/> - datatype attribute for the ppid entity of a process_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitempriority">
        <sch:rule context="unix-sc:process_item/unix-sc:priority">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the priority entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemscheduling_class">
        <sch:rule context="unix-sc:process_item/unix-sc:scheduling_class">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the scheduling_class entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemstart_time">
        <sch:rule context="unix-sc:process_item/unix-sc:start_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the start_time entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemtty">
        <sch:rule context="unix-sc:process_item/unix-sc:tty">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the tty entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixprocessitemuser_id">
        <sch:rule context="unix-sc:process_item/unix-sc:user_id">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user_id entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixrlitemservice_name">
        <sch:rule context="unix-sc:runlevel_item/unix-sc:service_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the service_name entity of a runlevel_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixrlitemrunlevel">
        <sch:rule context="unix-sc:runlevel_item/unix-sc:runlevel">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the runlevel entity of a runlevel_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixrlitemstart">
        <sch:rule context="unix-sc:runlevel_item/unix-sc:start">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the start entity of a runlevel_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unixrlitemkill">
        <sch:rule context="unix-sc:runlevel_item/unix-sc:kill">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the kill entity of a runlevel_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitempath">
        <sch:rule context="unix-sc:sccs_item/unix-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemfilename">
        <sch:rule context="unix-sc:sccs_item/unix-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemmodule_name">
        <sch:rule context="unix-sc:sccs_item/unix-sc:module_name">
            <sch:assert test="@datatype='int'">item <value-of select="../@id"/> - datatype attribute for the module_name entity of a process_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemmodule_type">
        <sch:rule context="unix-sc:sccs_item/unix-sc:module_type">
            <sch:assert test="@datatype='int'">item <value-of select="../@id"/> - datatype attribute for the module_type entity of a process_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemrelease">
        <sch:rule context="unix-sc:sccs_item/unix-sc:release">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the release entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemlevel">
        <sch:rule context="unix-sc:sccs_item/unix-sc:level">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the level entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitembranch">
        <sch:rule context="unix-sc:sccs_item/unix-sc:branch">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the branch entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemsequence">
        <sch:rule context="unix-sc:sccs_item/unix-sc:sequence">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the sequence entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="sccsitemwhat_string">
        <sch:rule context="unix-sc:sccs_item/unix-sc:what_string">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the what_string entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemusername">
        <sch:rule context="unix-sc:shadow_item/unix-sc:username">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the username entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitempassword">
        <sch:rule context="unix-sc:shadow_item/unix-sc:password">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the password entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemchg_lst">
        <sch:rule context="unix-sc:shadow_item/unix-sc:chg_lst">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the chg_lst entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemchg_allow">
        <sch:rule context="unix-sc:shadow_item/unix-sc:chg_allow">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the chg_allow entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemchg_req">
        <sch:rule context="unix-sc:shadow_item/unix-sc:chg_req">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the chg_req entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemexp_warn">
        <sch:rule context="unix-sc:shadow_item/unix-sc:exp_warn">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the exp_warn entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemexp_inact">
        <sch:rule context="unix-sc:shadow_item/unix-sc:exp_inact">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the exp_inact entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemexp_date">
        <sch:rule context="unix-sc:shadow_item/unix-sc:exp_date">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the exp_date entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="shadowitemflag">
        <sch:rule context="unix-sc:shadow_item/unix-sc:flag">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the flag entity of a shadow_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unameitemmachine_class">
        <sch:rule context="unix-sc:uname_item/unix-sc:machine_class">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the machine_class entity of a uname_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unameitemnode_name">
        <sch:rule context="unix-sc:uname_item/unix-sc:node_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the node_name entity of a uname_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unameitemos_name">
        <sch:rule context="unix-sc:uname_item/unix-sc:os_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the os_name entity of a uname_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unameitemos_release">
        <sch:rule context="unix-sc:uname_item/unix-sc:os_release">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the os_release entity of a uname_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unameitemos_version">
        <sch:rule context="unix-sc:uname_item/unix-sc:os_version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the os_version entity of a uname_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="unameitemprocessor_type">
        <sch:rule context="unix-sc:uname_item/unix-sc:processor_type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the processor_type entity of a uname_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemprotocol">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:protocol">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the protocol entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemservice_name">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:service_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the service_name entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemflags">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:flags">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the flags entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemnoaccess">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:no_access">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the no_access entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemonlyfrom">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:only_from">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the only_from entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemport">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:port">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the port entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemserver">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:server">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the server entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemserver_arguments">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:server_arguments">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the server_arguments entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemsockettype">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:socket_type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the socket_type entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemtype">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the type entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemuser">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:user">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user entity of an xinetd_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemwait">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:wait">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the wait entity of an xinetd_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="xinetditemdisabled">
        <sch:rule context="unix-sc:xinetd_item/unix-sc:disabled">
            <sch:assert test="@datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the disabled entity of an xinetd_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsecurity_principle">
        <sch:rule context="win-sc:accesstoken_item/win-sc:security_principle">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the security_principle entity of an accesstoken_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseassignprimarytokenprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seassignprimarytokenprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seassignprimarytokenprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseauditprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seauditprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seauditprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsebackupprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sebackupprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sebackupprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsechangenotifyprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sechangenotifyprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sechangenotifyprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsecreateglobalprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:secreateglobalprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the secreateglobalprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsecreatepagefileprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:secreatepagefileprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the secreatepagefileprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsecreatepermanentprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:secreatepermanentprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the secreatepermanentprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsecreatetokenprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:secreatetokenprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the secreatetokenprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsedebugprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sedebugprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sedebugprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseenabledelegationprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seenabledelegationprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seenabledelegationprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseimpersonateprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seimpersonateprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seimpersonateprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseincreasebasepriorityprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seincreasebasepriorityprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seincreasebasepriorityprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseincreasequotaprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seincreasequotaprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seincreasequotaprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseloaddriverprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seloaddriverprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seloaddriverprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemselockmemoryprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:selockmemoryprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the selockmemoryprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsemachineaccountprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:semachineaccountprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the semachineaccountprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsemanagevolumeprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:semanagevolumeprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the semanagevolumeprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseprofilesingleprocessprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seprofilesingleprocessprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seprofilesingleprocessprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseremoteshutdownprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seremoteshutdownprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seremoteshutdownprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemserestoreprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:serestoreprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the serestoreprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsesecurityprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sesecurityprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sesecurityprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseshutdownprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seshutdownprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seshutdownprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsesyncagentprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sesyncagentprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sesyncagentprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsesystemenvironmentprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sesystemenvironmentprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sesystemenvironmentprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsesystemprofileprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sesystemprofileprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sesystemprofileprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsesystemtimeprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sesystemtimeprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sesystemtimeprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsetakeownershipprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:setakeownershipprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the setakeownershipprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsetcbprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:setcbprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the setcbprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseundockprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seundockprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seundockprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseunsolicitedinputprivilege">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seunsolicitedinputprivilege">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seunsolicitedinputprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsebatchlogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sebatchlogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sebatchlogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseinteractivelogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seinteractivelogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seinteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsenetworklogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:senetworklogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the senetworklogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseremoteinteractivelogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seremoteinteractivelogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seremoteinteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemseservicelogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:seservicelogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the seservicelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsedenybatchLogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sedenybatchLogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sedenybatchLogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsedenyinteractivelogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sedenyinteractivelogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sedenyinteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsedenynetworklogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sedenynetworklogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sedenynetworklogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsedenyremoteInteractivelogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sedenyremoteInteractivelogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sedenyremoteInteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="atitemsedenyservicelogonright">
        <sch:rule context="win-sc:accesstoken_item/win-sc:sedenyservicelogonright">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the sedenyservicelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aditemnaming_context">
        <sch:rule context="win-sc:activedirectory_item/win-sc:naming_context">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the naming_context entity of an activedirectory_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aditemrelative_dn">
        <sch:rule context="win-sc:activedirectory_item/win-sc:relative_dn">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the relative_dn entity of an activedirectory_item should be 'string'</sch:assert>
            <sch:assert test="not(@xsi:nil='true') or ../win-sc:attribute/@xsi:nil='true'">
                <value-of select="../@id"/> - attribute entity must be nil when relative_dn is nil</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aditemattribute">
        <sch:rule context="win-sc:activedirectory_item/win-sc:attribute">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the attribute entity of an activedirectory_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aditemobject_class">
        <sch:rule context="win-sc:activedirectory_item/win-sc:object_class">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the object_class entity of an activedirectory_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aditemadstype">
        <sch:rule context="win-sc:activedirectory_item/win-sc:adstype">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the adstype entity of an activedirectory_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemaccount_logon">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:account_logon">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the account_logon entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemaccount_management">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:account_management">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the account_management entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemdetailed_tracking">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:detailed_tracking">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the detailed_tracking entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemdirectory_service_access">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:directory_service_access">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the directory_service_access entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemlogon">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:logon">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the logon entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemobject_access">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:object_access">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the object_access entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitempolicy_change">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:policy_change">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the policy_change entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemprivilege_use">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:privilege_use">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the privilege_use entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="aepitemsystem">
        <sch:rule context="win-sc:auditeventpolicy_item/win-sc:system">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the system entity of an auditeventpolicy_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitempath">
        <sch:rule context="win-sc:file_item/win-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemfilename">
        <sch:rule context="win-sc:file_item/win-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemowner">
        <sch:rule context="win-sc:file_item/win-sc:owner">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the owner entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemsize">
        <sch:rule context="win-sc:file_item/win-sc:size">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the size entity of a file_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitema_time">
        <sch:rule context="win-sc:file_item/win-sc:a_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the a_time entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemc_time">
        <sch:rule context="win-sc:file_item/win-sc:c_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the c_time entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemm_time">
        <sch:rule context="win-sc:file_item/win-sc:m_time">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the m_time entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemms_checksum">
        <sch:rule context="win-sc:file_item/win-sc:ms_checksum">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the ms_checksum entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemversion">
        <sch:rule context="win-sc:file_item/win-sc:version">
            <sch:assert test="not(@datatype) or @datatype='version'">item <value-of select="../@id"/> - datatype attribute for the version entity of a file_item should be 'version'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemtype">
        <sch:rule context="win-sc:file_item/win-sc:type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the type entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemdevelopment_class">
        <sch:rule context="win-sc:file_item/win-sc:development_class">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the development_class entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemcompany">
        <sch:rule context="win-sc:file_item/win-sc:company">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the company entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileiteminternalname">
        <sch:rule context="win-sc:file_item/win-sc:internal_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the internal_name entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemlanguage">
        <sch:rule context="win-sc:file_item/win-sc:language">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the language entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemoriginalfilename">
        <sch:rule context="win-sc:file_item/win-sc:original_filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the original_filename entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemproductname">
        <sch:rule context="win-sc:file_item/win-sc:product_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the product_name entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileitemproductversion">
        <sch:rule context="win-sc:file_item/win-sc:product_version">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the product_version entity of a file_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititempath">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfilename">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemtrustee_name">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:trustee_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_name entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemtrustee_domain">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:trustee_domain">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemtrustee_sid">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:trustee_sid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemstandard_delete">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_delete">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_delete entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemstandard_read_control">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_read_control">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemstandard_write_dac">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_write_dac">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemstandard_write_owner">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_write_owner">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemstandard_synchronize">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_synchronize">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for thestandard_synchronize entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemaccess_system_security">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:access_system_security">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the access_system_security entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemgeneric_read">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_read">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_read entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemgeneric_write">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_write">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_write entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemgeneric_execute">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_execute">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_execute entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemgeneric_all">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_all">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_all entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_read_data">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_read_data">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_read_data entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_write_data">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_write_data">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_write_data entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_append_data">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_append_data">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_append_data entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_read_ea">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_read_ea">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_read_ea entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_write_ea">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_write_ea">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_write_ea entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_execute">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_execute">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_execute entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_delete_child">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_delete_child">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_delete_child entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_read_attributes">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_read_attributes">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_read_attributes entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="fileaudititemfile_write_attributes">
        <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_write_attributes">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_write_attributes entity of a fileauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitempath">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the path entity of a fileeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfilename">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:filename">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the filename entity of a fileeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemtrustee_name">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:trustee_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_name entity of a fileeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemtrustee_domain">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:trustee_domain">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a fileeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemtrustee_sid">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:trustee_sid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a fileeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemstandard_delete">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_delete">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_delete entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemstandard_read_control">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_read_control">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemstandard_write_dac">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_write_dac">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemstandard_write_owner">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_write_owner">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemstandard_synchronize">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_synchronize">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemaccess_system_security">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:access_system_security">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the access_system_security entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemgeneric_read">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_read">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_read entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemgeneric_write">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_write">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_write entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemgeneric_execute">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_execute">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_execute entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemgeneric_all">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_all">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_all entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_read_data">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_read_data">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_read_data entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_write_data">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_write_data">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_write_data entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_append_data">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_append_data">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_append_data entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_read_ea">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_read_ea">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_read_ea entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_write_ea">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_write_ea">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_write_ea entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_execute">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_execute">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_execute entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_delete_child">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_delete_child">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_delete_child entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_read_attributes">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_read_attributes">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_read_attributes entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="feitemfile_write_attributes">
        <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_write_attributes">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_write_attributes entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="groupitemgroup">
        <sch:rule context="win-sc:group_item/win-sc:group">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the group entity of a group_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="groupitemuser">
        <sch:rule context="win-sc:group_item/win-sc:user">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user entity of a group_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemname">
        <sch:rule context="win-sc:interface_item/win-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemindex">
        <sch:rule context="win-sc:interface_item/win-sc:index">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the index entity of an interface_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemtype">
        <sch:rule context="win-sc:interface_item/win-sc:type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the type entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemhardware_addr">
        <sch:rule context="win-sc:interface_item/win-sc:hardware_addr">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the hardware_addr entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceiteminet_addr">
        <sch:rule context="win-sc:interface_item/win-sc:inet_addr">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the inet_addr entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitembroadcast_addr">
        <sch:rule context="win-sc:interface_item/win-sc:broadcast_addr">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the broadcast_addr entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemnetmask">
        <sch:rule context="win-sc:interface_item/win-sc:netmask">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the netmask entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="interfaceitemaddr_type">
        <sch:rule context="win-sc:interface_item/win-sc:addr_type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the addr_type entity of an interface_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="lpitemforce_logoff">
        <sch:rule context="win-sc:lockoutpolicy_item/win-sc:force_logoff">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the force_logoff entity of a lockoutpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="lpitemlockout_duration">
        <sch:rule context="win-sc:lockoutpolicy_item/win-sc:lockout_duration">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the lockout_duration entity of a lockoutpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="lpitemlockout_observation_window">
        <sch:rule context="win-sc:lockoutpolicy_item/win-sc:lockout_observation_window">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the lockout_observation_window entity of a lockoutpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="lpitemlockout_threshold">
        <sch:rule context="win-sc:lockoutpolicy_item/win-sc:lockout_threshold">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the lockout_threshold entity of a lockoutpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="metabaseitemkey">
        <sch:rule context="win-sc:metabase_item/win-sc:key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key entity of a metabase_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="metabaseitemid">
        <sch:rule context="win-sc:metabase_item/win-sc:id">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the id entity of a metabase_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="metabaseitemname">
        <sch:rule context="win-sc:metabase_item/win-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a metabase_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="metabaseitemuser_type">
        <sch:rule context="win-sc:metabase_item/win-sc:user_type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user_type entity of a metabase_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="metabaseitemdata_type">
        <sch:rule context="win-sc:metabase_item/win-sc:data_type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the data_type entity of a metabase_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ppitemmax_passwd_age">
        <sch:rule context="win-sc:passwordpolicy_item/win-sc:max_passwd_age">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the max_passwd_age entity of a passwordpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ppitemmin_passwd_age">
        <sch:rule context="win-sc:passwordpolicy_item/win-sc:min_passwd_age">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the min_passwd_age entity of a passwordpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ppitemmin_passwd_len">
        <sch:rule context="win-sc:passwordpolicy_item/win-sc:min_passwd_len">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the min_passwd_len entity of a passwordpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ppitempassword_hist_len">
        <sch:rule context="win-sc:passwordpolicy_item/win-sc:password_hist_len">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the password_hist_len entity of a passwordpolicy_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ppitempassword_complexity">
        <sch:rule context="win-sc:passwordpolicy_item/win-sc:password_complexity">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the password_complexity entity of a passwordpolicy_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="ppitemreversible_encryption">
        <sch:rule context="win-sc:passwordpolicy_item/win-sc:reversible_encryption">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the reversible_encryption entity of a passwordpolicy_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="portitemlocal_address">
        <sch:rule context="win-sc:port_item/win-sc:local_address">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the local_address entity of a port_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="portitemlocal_port">
        <sch:rule context="win-sc:port_item/win-sc:local_port">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the local_port entity of a port_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="portitemprotocol">
        <sch:rule context="win-sc:port_item/win-sc:protocol">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the protocol entity of a port_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="portitempid">
        <sch:rule context="win-sc:port_item/win-sc:pid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the pid entity of a port_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="processitemcommand_line">
        <sch:rule context="win-sc:process_item/win-sc:command_line">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the command_line entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="processitempid">
        <sch:rule context="win-sc:process_item/win-sc:pid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the pid entity of a process_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="processitemppid">
        <sch:rule context="win-sc:process_item/win-sc:ppid">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the ppid entity of a process_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="processitempriority">
        <sch:rule context="win-sc:process_item/win-sc:priority">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the priority entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="processitemimage_path">
        <sch:rule context="win-sc:process_item/win-sc:image_path">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the image_path entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="processitemcurrent_dir">
        <sch:rule context="win-sc:process_item/win-sc:current_dir">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the current_dir entity of a process_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="regitemhive">
        <sch:rule context="win-sc:registry_item/win-sc:hive">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the hive entity of a registry_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="regitemkey">
        <sch:rule context="win-sc:registry_item/win-sc:key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key entity of a registry_item should be 'string'</sch:assert>
            <sch:assert test="not(@xsi:nil='true') or ../win-sc:name/@xsi:nil='true'">
                <value-of select="../@id"/> - name entity must be nil when key is nil</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="regitemname">
        <sch:rule context="win-sc:registry_item/win-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a registry_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="regitemtype">
        <sch:rule context="win-sc:registry_item/win-sc:type">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the type entity of a registry_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemhive">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:hive">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the hive entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemtrustee_name">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:trustee_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_name entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemtrustee_domain">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:trustee_domain">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemtrustee_sid">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:trustee_sid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemstandard_delete">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_delete">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_delete entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemstandard_read_control">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_read_control">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemstandard_write_dac">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_write_dac">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemstandard_write_owner">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_write_owner">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemstandard_synchronize">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_synchronize">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemaccess_system_security">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:access_system_security">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the access_system_security entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemgeneric_read">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_read">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_read entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemgeneric_write">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_write">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_write entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemgeneric_execute">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_execute">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_execute entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemgeneric_all">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_all">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the generic_all entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_query_value">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_query_value">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_query_value entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_set_value">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_set_value">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_set_value entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_create_sub_key">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_create_sub_key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_create_sub_key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_enumerate_sub_keys">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_enumerate_sub_keys">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_enumerate_sub_keys entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_notify">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_notify">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_notify entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_create_link">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_create_link">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_create_link entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_wow64_64key">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_wow64_64key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_wow64_64key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_wow64_32key">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_wow64_32key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_wow64_32key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="rapitemkey_wow64_res">
        <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_wow64_res">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key_wow64_res entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemhive">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:hive">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the hive entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the key entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemtrustee_name">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:trustee_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_name entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemtrustee_domain">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:trustee_domain">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemtrustee_sid">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:trustee_sid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemstandard_delete">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_delete">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_delete entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemstandard_read_control">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_read_control">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemstandard_write_dac">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_write_dac">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemstandard_write_owner">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_write_owner">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemstandard_synchronize">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_synchronize">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemaccess_system_security">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:access_system_security">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the access_system_security entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemgeneric_read">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_read">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_read entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemgeneric_write">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_write">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_write entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemgeneric_execute">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_execute">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_execute entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemgeneric_all">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_all">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the generic_all entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_query_value">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_query_value">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_query_value entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_set_value">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_set_value">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_set_value entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_create_sub_key">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_create_sub_key">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_create_sub_key entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_enumerate_sub_keys">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_enumerate_sub_keys">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_enumerate_sub_keys entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_notify">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_notify">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_notify entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_create_link">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_create_link">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_create_link entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_wow64_64key">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_wow64_64key">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_wow64_64key entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_wow64_32key">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_wow64_32key">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_wow64_32key entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="reritemkey_wow64_res">
        <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_wow64_res">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the key_wow64_res entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="siditemtrustee_name">
        <sch:rule context="win-sc:sid_item/win-sc:trustee_name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_name entity of a sid_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="siditemtrustee_sid">
        <sch:rule context="win-sc:sid_item/win-sc:trustee_sid">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a sid_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="siditemtrustee_domain">
        <sch:rule context="win-sc:sid_item/win-sc:trustee_domain">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a sid_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="useritemuser">
        <sch:rule context="win-sc:user_item/win-sc:user">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the user entity of a user_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="useritemenabled">
        <sch:rule context="win-sc:user_item/win-sc:enabled">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the enabled entity of a user_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="useritemgroup">
        <sch:rule context="win-sc:user_item/win-sc:group">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for a group entity of a user_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemrootpath">
        <sch:rule context="win-sc:volume_item/win-sc:rootpath">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the rootpath entity of a volume_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_system">
        <sch:rule context="win-sc:volume_item/win-sc:file_system">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the file_system entity of a volume_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemname">
        <sch:rule context="win-sc:volume_item/win-sc:name">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the name entity of a volume_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemvolume_max_component_length">
        <sch:rule context="win-sc:volume_item/win-sc:volume_max_component_length">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the volume_max_component_length entity of a volume_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemserial_number">
        <sch:rule context="win-sc:volume_item/win-sc:serial_number">
            <sch:assert test="not(@datatype) or @datatype='int'">item <value-of select="../@id"/> - datatype attribute for the serial_number entity of a volume_item should be 'int'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_case_sensitive_search">
        <sch:rule context="win-sc:volume_item/win-sc:file_case_sensitive_search">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_case_sensitive_search entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_case_preserved_names">
        <sch:rule context="win-sc:volume_item/win-sc:file_case_preserved_names">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_case_preserved_names entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_unicode_on_disk">
        <sch:rule context="win-sc:volume_item/win-sc:file_unicode_on_disk">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_unicode_on_disk entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_persistent_acls">
        <sch:rule context="win-sc:volume_item/win-sc:file_persistent_acls">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_persistent_acls entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_file_compression">
        <sch:rule context="win-sc:volume_item/win-sc:file_file_compression">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_file_compression entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_volume_quotas">
        <sch:rule context="win-sc:volume_item/win-sc:file_volume_quotas">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_volume_quotas entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_supports_sparse_files">
        <sch:rule context="win-sc:volume_item/win-sc:file_supports_sparse_files">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_supports_sparse_files entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_supports_reparse_points">
        <sch:rule context="win-sc:volume_item/win-sc:file_supports_reparse_points">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_supports_reparse_points entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_supports_remote_storage">
        <sch:rule context="win-sc:volume_item/win-sc:file_supports_remote_storage">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_supports_remote_storage entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_volume_is_compressed">
        <sch:rule context="win-sc:volume_item/win-sc:file_volume_is_compressed">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_volume_is_compressed entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_supports_object_ids">
        <sch:rule context="win-sc:volume_item/win-sc:file_supports_object_ids">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_supports_object_ids entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_supports_encryption">
        <sch:rule context="win-sc:volume_item/win-sc:file_supports_encryption">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_supports_encryption entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_named_streams">
        <sch:rule context="win-sc:volume_item/win-sc:file_named_streams">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_named_streams entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="volitemfile_read_only_volume">
        <sch:rule context="win-sc:volume_item/win-sc:file_read_only_volume">
            <sch:assert test="not(@datatype) or @datatype='boolean'">item <value-of select="../@id"/> - datatype attribute for the file_read_only_volume entity of a volume_item should be 'boolean'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="wmiitemnamespace">
        <sch:rule context="win-sc:wmi_item/win-sc:namespace">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the namespace entity of a wmi_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="wmiitemwql">
        <sch:rule context="win-sc:wmi_item/win-sc:wql">
            <sch:assert test="not(@datatype) or @datatype='string'">item <value-of select="../@id"/> - datatype attribute for the wql entity of a wmi_item should be 'string'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:diagnostics/>
</sch:schema>
