--
-- OVAL-id: OVAL996
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2000-0979' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 98 Installed

	(SELECT 'Windows 98 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
		EntryName = 'Version' AND
		EntryValue = 'Windows 98')

AND EXISTS

	-- File %windir%\system\vserver.vxd version is less than 4.10.2001

	(SELECT 'File %windir%\system\vserver.vxd version is less than 4.10.2001' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system\vserver.vxd' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 10 OR (Version2 = 10 AND
		(Version3 < 2001 OR Version3 = 2001 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- Patch 273991USA8.EXE Installed

	(SELECT 'Patch 273991USA8.EXE Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\UtilMan{5c773859-bb96- 48fa-875b-6a58aae072f4}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

