--
-- OVAL-id: OVAL865
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0988' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdepim version is less than 3.1.3-3.3

	(SELECT 'kdepim version is less than 3.1.3-3.3' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdepim' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1.3' AND
		RPMTestedRelease = '3.3' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/share/services/kfile_vcf.desktop is readable
	(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM Placeholder WHERE

	EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			UREAD = '1')

	OR EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

