--
-- OVAL-id: OVAL846
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0111' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable configuration
	(SELECT 'Vulnerable configuration' FROM Placeholder WHERE

	EXISTS
		-- gdk-pixbuf version is less than 0.22.0-6.1.0

		(SELECT 'gdk-pixbuf version is less than 0.22.0-6.1.0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.1.0' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- gdk-pixbuf-devel version is less than 0.22.0-6.1.0

		(SELECT 'gdk-pixbuf-devel version is less than 0.22.0-6.1.0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf-devel' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.1.0' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- gdk-pixbuf-gnome version is less than 0.22.0-6.1.0

		(SELECT 'gdk-pixbuf-gnome version is less than 0.22.0-6.1.0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf-gnome' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.1.0' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

