--
-- OVAL-id: OVAL71
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0344' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File sqlservr.exe version3 is less than 296

	(SELECT 'File sqlservr.exe version3 is less than 296' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 296 OR Version3 = 296 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Mixed Mode Enabled

	(SELECT 'Mixed Mode Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer' AND
		EntryName = 'LoginMode' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

