--
-- OVAL-id: OVAL61
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0366' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- RAS Phonebook

	(SELECT 'RAS Phonebook' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ras\CurrentVersion' AND
		EntryName = 'PathName' AND
		EntryValue = 'RASPHONE.PBK')

AND EXISTS

	-- File %windir%\system32\rasapi32.dll version is less than 4.0.1381.7140

	(SELECT 'File %windir%\system32\rasapi32.dll version is less than 4.0.1381.7140' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rasman.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7140))))))

AND NOT EXISTS

	-- Patch Q318138 Installed

	(SELECT 'Patch Q318138 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q318138' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- RAS Enabled

	(SELECT 'RAS Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RasMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

