--
-- OVAL-id: OVAL4493
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0572' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- 64-Bit version of Windows is installed

	(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'ia64')

AND EXISTS

	-- a vulnerable version of grpconv.exe exists
	(SELECT 'a vulnerable version of grpconv.exe exists' FROM Placeholder WHERE

	EXISTS
		-- the version of grpconv.exe (system32) is less than 5.2.3790.205

		(SELECT 'the version of grpconv.exe (system32) is less than 5.2.3790.205' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\grpconv.exe' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 205))))))

	OR EXISTS
		-- the version of grpconv.exe (syswow64) is less than 5.2.3790.205

		(SELECT 'the version of grpconv.exe (syswow64) is less than 5.2.3790.205' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\syswow64\shell32.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 205)))))))

AND NOT EXISTS

	-- the patch q841356 is installed (Hotfix key)

	(SELECT 'the patch q841356 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841356' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

