--
-- OVAL-id: OVAL43
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

