--
-- OVAL-id: OVAL423
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0136' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- lprng version is less than 3.8.19-3.1

	(SELECT 'lprng version is less than 3.8.19-3.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'lprng' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.8.19' AND
		RPMTestedRelease = '3.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- psbanner is world-executable

	(SELECT 'psbanner is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/usr/libexec/filters/psbanner' AND
		OEXEC = '1')

AND EXISTS

	-- lpd listening on the network

	(SELECT 'lpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%lpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

