--
-- OVAL-id: OVAL2621
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 114796-04 or later installed

	(SELECT 'Patch 114796-04 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '114796' AND
		PatchVersion >= '04')

AND EXISTS

	-- Sun Crypto Accelerator 4000 software installed

	(SELECT 'Sun Crypto Accelerator 4000 software installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWkcl2r')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

