--
-- OVAL-id: OVAL250
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0139' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- krb5-libs version is less than 1.2.7-14

	(SELECT 'krb5-libs version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'krb5-libs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.7' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- krb5-server or krb5-workstation installed
	(SELECT 'krb5-server or krb5-workstation installed' FROM Placeholder WHERE

	EXISTS
		-- krb5-server version is less than 1.2.7-14

		(SELECT 'krb5-server version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'krb5-server' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.2.7' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- krb5-workstation version is less than 1.2.7-14

		(SELECT 'krb5-workstation version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'krb5-workstation' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.2.7' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

