--
-- OVAL-id: OVAL2245
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0420' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of shell32.dll is less than 6.0.2800.1556

	(SELECT 'the version of shell32.dll is less than 6.0.2800.1556' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1556))))))

AND NOT EXISTS

	-- the patch kb839645 is installed

	(SELECT 'the patch kb839645 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839645' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP 64-bit with SP1 (or earlier) installed
	(SELECT 'Windows XP 64-bit with SP1 (or earlier) installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP (sp1 or earlier) is installed
		(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

		EXISTS
			-- Windows XP is installed

			(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '5.1')

		AND NOT EXISTS
			-- Win2K/XP/2003 service pack 2 (or later) is installed

			(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

