--
-- OVAL-id: OVAL2002
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0523' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Kerberos 5 installed

	(SELECT 'Kerberos 5 installed' FROM Solaris_FileAttributes WHERE
		FilePath = '/etc/krb5/krb5.conf')

AND EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 112908-16 or later installed

	(SELECT 'Patch 112908-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112908' AND
		PatchVersion >= '16')

AND NOT EXISTS

	-- Patch 112536-05 or later installed

	(SELECT 'Patch 112536-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112536' AND
		PatchVersion >= '05')

AND NOT EXISTS

	-- Patches 112237-11 and 112390-09 or greater installed
	(SELECT 'Patches 112237-11 and 112390-09 or greater installed' FROM Placeholder WHERE

	EXISTS
		-- Patch 112237-11 or later installed

		(SELECT 'Patch 112237-11 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '112237' AND
			PatchVersion >= '11')

	AND EXISTS
		-- Patch 112390-09 or later installed

		(SELECT 'Patch 112390-09 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '112390' AND
			PatchVersion >= '09'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- System is configured to use kerberos

	-- unknown_test
	-- NOTE: grep default_realm /etc/krb5/krb5.conf | grep -v __default_realm__ True if "default_realm = EXAMPLE.COM" where EXAMPLE.COM is a kerberos domain

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- Solaris Kerberos explicit or rules-based mapping

	-- unknown_test
	-- NOTE: grep ^auth_to_local.* /etc/krb5/krb5.conf True if anything is returned

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

--
-- ### END VULNERABLE CONFIGURATION
;

