--
-- OVAL-id: OVAL2
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0140' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- balsa version is less than 2.0.6-2

	(SELECT 'balsa version is less than 2.0.6-2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'balsa' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.6' AND
		RPMTestedRelease = '2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/balsa is executable
	(SELECT '/usr/bin/balsa is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/balsa is executable

		(SELECT '/usr/bin/balsa is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/balsa' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/balsa is executable

		(SELECT '/usr/bin/balsa is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/balsa' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/balsa is executable

		(SELECT '/usr/bin/balsa is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/balsa' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

