--
-- OVAL-id: OVAL18
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0070' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of shell32.dll is less than 4.0.1381.7116

	(SELECT 'the version of shell32.dll is less than 4.0.1381.7116' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7116))))))

AND NOT EXISTS

	-- Patch Q313829 Installed

	(SELECT 'Patch Q313829 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313829' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

