--
-- OVAL-id: OVAL11
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0796' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File snmpdx exists

	(SELECT 'File snmpdx exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/snmpdx')

AND NOT EXISTS

	-- Patch 108869-16 or later installed

	(SELECT 'Patch 108869-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108869' AND
		PatchVersion >= '16')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpdx running

	(SELECT 'snmpdx running' FROM Solaris_PSInfo WHERE
		Command LIKE '%snmpdx%')

--
-- ### END VULNERABLE CONFIGURATION
;

