--
-- OVAL-id: OVAL1008
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0199' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of helpctr.exe exists on XP
	(SELECT 'a vulnerable version of helpctr.exe exists on XP' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of helpctr.exe exists
		(SELECT '32-bit version of Windows and a vulnerable version of helpctr.exe exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of helpctr.exe exists exists depending on service pack level
			(SELECT 'a vulnerable version of helpctr.exe exists exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- service pack 1 or earlier is installed and helpctr.exe is less than 5.1.2600.137
				(SELECT 'service pack 1 or earlier is installed and helpctr.exe is less than 5.1.2600.137' FROM Placeholder WHERE

				NOT EXISTS
					-- Win2K/XP/2003 service pack 2 (or later) is installed

					(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

				AND EXISTS
					-- the version of helpctr.exe is less than 5.1.2600.137

					(SELECT 'the version of helpctr.exe is less than 5.1.2600.137' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\helpctr.exe' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 137)))))))

			OR EXISTS
				-- service pack 2 is installed and helpctr.exe is less than 5.1.2600.1515
				(SELECT 'service pack 2 is installed and helpctr.exe is less than 5.1.2600.1515' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 2 is installed

					(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 2')

				AND EXISTS
					-- the version of helpctr.exe is less than 5.1.2600.1515

					(SELECT 'the version of helpctr.exe is less than 5.1.2600.1515' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\helpctr.exe' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1515)))))))))

	OR EXISTS
		-- 64-bit version of Windows and helpctr.exe is less than 5.1.2600.1515
		(SELECT '64-bit version of Windows and helpctr.exe is less than 5.1.2600.1515' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of helpctr.exe is less than 5.1.2600.1515

			(SELECT 'the version of helpctr.exe is less than 5.1.2600.1515' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\helpctr.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1515))))))))

AND NOT EXISTS

	-- the patch kb840374 is installed

	(SELECT 'the patch kb840374 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840374' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- the HCP Protocol is registered

	(SELECT 'the HCP Protocol is registered' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\HCP')

--
-- ### END VULNERABLE CONFIGURATION
;

