DROP TABLE RedHat_FileAttributes;
DROP TABLE RedHat_InetListeningServers;
DROP TABLE RedHat_Passwd;
DROP TABLE RedHat_PSInfo;
DROP TABLE RedHat_RPMinfo;
DROP TABLE RedHat_RPMVersionCompare;
DROP TABLE RedHat_Shadow;
DROP TABLE RedHat_Uname;


CREATE TABLE RedHat_FileAttributes
	(FilePath varchar(4096), 
	FileType varchar(32),
	UserID integer,
	GroupID integer,
	Atime integer,
	Ctime integer,
	Mtime integer,
	MD5 varchar(128),
	SUID char,
	SGID char,
	STICKY char,
	UREAD char,
	UWRITE char,
	UEXEC char,
	GREAD char,
	GWRITE char,
	GEXEC char,
	OREAD char,
	OWRITE char,
	OEXEC char);



CREATE TABLE RedHat_InetListeningServers
	(Protocol varchar(8),
	LocalFullAddress varchar(128),
	LocalAddress varchar(128),
	LocalPort integer,
	ForeignFullAddress varchar(128),
	ForeignAddress varchar(128),
	ForeignPort integer,
	UserID integer,
	PID integer,
	ProgramName varchar(256));


CREATE TABLE RedHat_Passwd
	(Username varchar(128),
	Password varchar(32),
	UserID integer,
	GroupID integer,
	GCOS varchar(256),
	HomeDir varchar(4096),
	LoginShell varchar(4096));


CREATE TABLE RedHat_PSInfo
	(UserID varchar(128),
	PID integer,
	PPID integer,
	SchedulingClass varchar(16),
	Priority integer,
	StartTime varchar(32),
	TTY integer,
	ExecTime varchar(32),
	Command varchar(4096));


CREATE TABLE RedHat_RPMinfo
	(RPMName varchar(256),
	RPMEpoch varchar(8),
	RPMVersion varchar(32),
	RPMRelease varchar(32),
	RPMArch varchar(32));


CREATE TABLE RedHat_RPMVersionCompare
	(RPMName varchar(256),
	RPMTestedEpoch varchar(8),
	RPMTestedVersion varchar(32),
	RPMTestedRelease varchar(32),
	RPMInstalledVersion varchar(16));


CREATE TABLE RedHat_Shadow
	(Username varchar(128),
	Password varchar(32),
	ChgLst integer,
	ChgAllow integer,
	ChgReq integer,
	ExpWarn integer,
	ExpInact integer,
	ExpDate integer,
	PswFlag varchar(32));


CREATE TABLE RedHat_Uname
	(OSName varchar(32),
	NodeName varchar(128),
	OSRelease varchar(32),
	OSVersion varchar(64),
	MachineClass varchar(32),
	ProcessorType varchar(32));
