--
-- OVAL-id: OVAL979
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0233' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- utempter version is less than 0.5.5-1.3EL.0

	(SELECT 'utempter version is less than 0.5.5-1.3EL.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'utempter' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.5.5' AND
		RPMTestedRelease = '1.3EL.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/utempter is executable
	(SELECT '/usr/sbin/utempter is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/utempter is executable

		(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/utempter' AND
			SGID = '1')

	AND EXISTS
		-- /usr/sbin/utempter is executable
		(SELECT '/usr/sbin/utempter is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/utempter is executable

			(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/utempter' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/utempter is executable

			(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/utempter' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/utempter is executable

			(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/utempter' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

