--
-- OVAL-id: OVAL957
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0116' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- a vulnerable version of rpcss.dll exists on Server 2003
	(SELECT 'a vulnerable version of rpcss.dll exists on Server 2003' FROM Placeholder WHERE

	EXISTS
		-- 32-bit machine a vulnerable version of rpcss.dll exists
		(SELECT '32-bit machine a vulnerable version of rpcss.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of rpcss.dll exists on non 64-bit Server 2003
			(SELECT 'a vulnerable version of rpcss.dll exists on non 64-bit Server 2003' FROM Placeholder WHERE

			EXISTS
				-- machine has followed the GDR update path and rpcss.dll is less than 5.2.3790.132

				-- unknown_test
				-- NOTE: 

				(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

			OR EXISTS
				-- machine has followed the QFE update path and rpcss.dll is less than 5.2.3790.142

				-- unknown_test
				-- NOTE: 

				(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)))

	OR EXISTS
		-- 64-bit machine and rpcss.dll is less than 5.2.3790.146
		(SELECT '64-bit machine and rpcss.dll is less than 5.2.3790.146' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of rpcss.dll is less than 5.2.3790.146

			(SELECT 'the version of rpcss.dll is less than 5.2.3790.146' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\rpcss.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 2 OR (Version2 = 2 AND
				(Version3 < 3790 OR Version3 = 3790 AND
				Version4 < 142))))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled

	(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
		EntryName = 'EnableDCOM' AND
		EntryValue = 'Y')

--
-- ### END VULNERABLE CONFIGURATION
;

