--
-- OVAL-id: OVAL956
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1041' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- Internet Explorer 5.5 SP2 or Internet Explorer 6.0 SP1 is installed
	(SELECT 'Internet Explorer 5.5 SP2 or Internet Explorer 6.0 SP1 is installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 6 Service Pack 1 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2800.1106')

	OR EXISTS
		-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.3790.0000')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of itss.dll is less than 5.2.3790.185

	(SELECT 'the version of itss.dll is less than 5.2.3790.185' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 185))))))

AND NOT EXISTS

	-- the patch kb840315 is installed

	(SELECT 'the patch kb840315 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840315' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- HTML Help is registered

	(SELECT 'HTML Help is registered' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\ITSProtocol')

--
-- ### END VULNERABLE CONFIGURATION
;

