--
-- OVAL-id: OVAL94
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0797' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File mibiisa exists

	(SELECT 'File mibiisa exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/mibiisa')

AND NOT EXISTS

	-- Patch 108869-16 or later installed

	(SELECT 'Patch 108869-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108869' AND
		PatchVersion >= '16')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mibiisa running

	(SELECT 'mibiisa running' FROM Solaris_PSInfo WHERE
		Command LIKE '%mibiisa%')

--
-- ### END VULNERABLE CONFIGURATION
;

