--
-- OVAL-id: OVAL932
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-1999-0736' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\code.asp is less than 4.0.1381.279

	(SELECT 'File %windir%\System32\code.asp is less than 4.0.1381.279' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\code.asp' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 279))))))

AND NOT EXISTS

	-- Patch Q232449 Installed

	(SELECT 'Patch Q232449 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q232449 ' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

